//
//  SpeakPropertyWrapper.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/22.
//

import UIKit

@propertyWrapper
struct BoundedDoubleNumber : Codable {
    private var value: Double
    private let min: Double
    private let max: Double

    init(wrappedValue initialValue: Double) {
        self.min = 0
        self.max = 1
        self.value = Swift.min(Swift.max(initialValue, min), max)
    }

    var wrappedValue: Double {
        get { value }
        set {
            value = Swift.min(Swift.max(newValue , min), max)
        }
    }
}


@propertyWrapper
struct BoundedZeroNumber : Codable {
    private var value: Int
    private let min: Int

    init(wrappedValue initialValue: Int) {
        self.min = 0
        self.value = Swift.max(initialValue, min)
    }

    var wrappedValue: Int {
        get { value }
        set {
            value = Swift.max(newValue , min)
        }
    }
    
}
