//
//  SpeakPermission.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/24.
//

import UIKit
import UserNotifications
import AVFoundation


class SpeakPermission: NSObject {
    
   class func requestNotificationPermission() {
        let center = UNUserNotificationCenter.current()
        center.getNotificationSettings { settings in
            switch settings.authorizationStatus {
            case .authorized:
                NotificationManager.scheduleDailyNotification()
                break
            case .denied:
                break
            case .notDetermined:
                center.requestAuthorization(options: [.alert, .sound, .badge]) { granted, error in
                    if granted {
                        NotificationManager.scheduleDailyNotification()
                    } else {
                    }
                }
                break
            default: break
            }
        }
    }
    
    class func checkNotificationPermission( _ complate:@escaping((Bool)->Void)) {
        UNUserNotificationCenter.current().getNotificationSettings { settings in
            switch settings.authorizationStatus {
            case .authorized:
                complate(true)
                break
            default:
                complate(false)
                break
            }
        }
    }
    
    
    // 检查相机权限状态
    static func checkCameraPermission(completion: @escaping (Bool) -> Void) {
        switch AVCaptureDevice.authorizationStatus(for: .video) {
        case .authorized:
            completion(true)
        case .notDetermined:
            // 未决定，请求权限
            AVCaptureDevice.requestAccess(for: .video) { granted in
                DispatchQueue.main.async {
                    completion(granted)
                }
            }
        case .denied, .restricted:
            // 被拒绝或受限制
            completion(false)
        @unknown default:
            completion(false)
        }
    }
}
