//
//  SpeakLoadingLabel.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/9/5.
//

import UIKit

class SpeakLoadingLabel: UILabel {

    
    override func awakeFromNib() {
        super.awakeFromNib()
        setup()
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setup()
    }
    
    private func setup() -> Void {
        activityView.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.top.bottom.equalToSuperview()
            make.width.equalTo(activityView.snp.height)
        }
    }
    
    override var text: String? {
        didSet{
            let rm = text?.replacingOccurrences(of: " ", with: "")
            if (rm?.count ?? 0) <= 0 {
                activityView.startAnimating()
            }else{
                activityView.stopAnimating()
            }
            activityView.isHidden = (rm?.count ?? 0) > 0
        }
    }
    
    private lazy var activityView: UIActivityIndicatorView = {
        let act = UIActivityIndicatorView(style: .medium)
        act.color = .gray
        self.addSubview(act)
        return act
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
}
