//
//  SpeakAutoLayout.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/9/3.
//

import UIKit

extension NSLayoutConstraint {
    @IBInspectable var isAuto:Bool {
        set {
            let const = newValue ? (UIScreen.main.bounds.height/874.0 * self.constant) : self.constant
            self.constant = const.isFinite ? const : 0 }
        get { return true }
    }
}

class SpeakAutoLayout: NSLayoutConstraint {

    static private let standardHeight: CGFloat = 874.0
    
    override func awakeFromNib() {
        super.awakeFromNib()
        updateConstant()
    }
    
    private func updateConstant() {
        let screenHeight = UIScreen.main.bounds.height
        guard SpeakAutoLayout.standardHeight.isFinite && screenHeight.isFinite else {
            self.constant = 0
            return
        }
        let calculatedConstant = (screenHeight /  SpeakAutoLayout.standardHeight) * self.constant
        if calculatedConstant.isFinite {
            self.constant = calculatedConstant
        } else {
            self.constant = 0
        }
    }
}

class SpeakAutoLayoutW: NSLayoutConstraint {

    static private let standardWidth: CGFloat = 402
    
    override func awakeFromNib() {
        super.awakeFromNib()
        updateConstant()
    }
    
    private func updateConstant() {
        let screenHeight = UIScreen.main.bounds.width
        guard SpeakAutoLayoutW.standardWidth.isFinite && screenHeight.isFinite else {
            self.constant = 0
            return
        }
        let calculatedConstant = (screenHeight /  SpeakAutoLayoutW.standardWidth) * self.constant
        if calculatedConstant.isFinite {
            self.constant = calculatedConstant
        } else {
            self.constant = 0
        }
    }
}
