//
//  SpeakEleExt.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/10.
//

import UIKit


extension UIFont {
    
    enum MontsStyle:String {
        case regular = "-Regular"
        case medium  = "-Medium"
        case semiBold = "-SemiBold"
        case bold = "-Bold"
        case YouSheBiao = "YouSheBiaoTiHei"
    }
    
    class func montserrat(_ type:MontsStyle = .regular ,size:CGFloat = 12) -> UIFont {
        if type == .YouSheBiao {
            return UIFont(name: type.rawValue, size: size) ?? UIFont.systemFont(ofSize: size)
        }else{
            let fontName = "Montserrat" + type.rawValue
            return UIFont(name: fontName, size: size) ?? UIFont.systemFont(ofSize: size)
        }
    }
    
    class func IAPFont(_ fontStr:String) -> UIFont? {
        if let fonts = fontStr.components(separatedBy: "#") as? [String],
           fonts.count == 3,
           let fontSize = Double(fonts.last ?? "") {
            let boldStr = fonts[safe:1] ?? ""
            let type = MontsStyle(rawValue: boldStr) ?? .regular
            var font = UIFont.systemFont(ofSize: fontSize, weight: .semibold)
            switch fonts.first {
            case "M":
                font = UIFont.montserrat(type,size: fontSize)
                break
            case "Y":
                font = UIFont.montserrat(.YouSheBiao,size: fontSize)
                break
            default:
                var tp:UIFont.Weight = .regular
                switch boldStr {
                case "regular":
                    tp = .regular
                    break
                case "medium":
                    tp = .medium
                    break
                case "semiBold":
                    tp = .semibold
                    break
                default:
                    tp = .bold
                }
                font = UIFont.systemFont(ofSize: fontSize, weight: tp)
                break
            }
            return font
        }
        return nil
    }
    
}
