//
//  SpeakEleImageFill.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/16.
//

import UIKit

class SpeakEleImageFill: UIImageView {

    var type : SpeakRoleState = .speakAI {
        didSet{
            let icon = UIImage(named: type == .speakAI ? "sp-guideQA-Qu" : (type == .speakUser ? "sp-guideQA-An" : "sp-guideQA-An1" )  )
            if let image = icon {
                let center = CGPoint(x: image.size.width / 2, y: image.size.height / 2)
                let insets = UIEdgeInsets(
                    top: center.y,
                    left: center.x,
                    bottom: center.y,
                    right: center.x
                )
                self.image = image.resizableImage(withCapInsets: insets, resizingMode: .tile)
            } else {
                self.image = nil
            }
        }
    }
    
}
