//
//  SpeakDialogueBaseTextView.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/8/7.
//

import UIKit

class SpeakDialogueBaseTextView: UITextField {

    var contentInset:UIEdgeInsets = UIEdgeInsets(top: 0, left: 10, bottom: 0, right: 10)
    
    open override func textRect(forBounds bounds: CGRect) -> CGRect {
        let frame = super.textRect(forBounds: bounds)
        return box(bound: frame)
    }

    open override func placeholderRect(forBounds bounds: CGRect) -> CGRect {
        let frame = super.placeholderRect(forBounds: bounds)
        return box(bound: frame)
    }

    open override func editingRect(forBounds bounds: CGRect) -> CGRect {
        let frame = super.editingRect(forBounds: bounds)
        return box(bound: frame)
    }
    
    private func box(bound:CGRect) -> CGRect {
        var frame = bound
        frame.origin.x = contentInset.left
//        frame.origin.y = contentInset.top
        frame.size.width -= (contentInset.left + contentInset.right)
//        frame.size.height -= (contentInset.top + contentInset.bottom)
        return frame
    }

}
