//
//  SpeakEleCorrectViewCtr.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/8/12.
//

import UIKit
import Lottie

class SpeakEleCorrectViewCtr: UIViewController {

    enum NetResults {
        case success
        case fail
        case search
    }
    
    @IBOutlet weak var ContentV: UIView!
    
    @IBOutlet weak var ANi: LottieAnimationView!
    @IBOutlet weak var Descp: UILabel!
    @IBOutlet weak var actionBtn: UIView!
    
    
    @IBOutlet weak var CorrectView: UIView!
    @IBOutlet weak var ErrorLabel: UILabel!
    @IBOutlet weak var ErrorAnyL: UILabel!
    @IBOutlet weak var SpeakScrollContentV: UIView!
    
    @IBOutlet weak var ScrollHeightConst: NSLayoutConstraint!
    
    @IBOutlet weak var SpeakBottomConst: NSLayoutConstraint!
    @IBOutlet weak var SpeakCorrectBottom: NSLayoutConstraint!
    
    let viewModel = SpeakEleCorrectViewModel()
    var lesssionId:Int?
    
    var net:NetResults = .search {
        didSet{
            if net == .success {
                CorrectView.isHidden = true
                lottieS.isHidden = false
                lottie.isHidden = true
                Descp.text = "Your answer is completely correct."
                lottieS.play()
                lottie.pause()
                Descp.isHidden = false
            }else if net == .fail {
                lottieS.isHidden = true
                lottie.isHidden = true
                Descp.isHidden = true
                CorrectView.isHidden = false
            }else{
                Descp.text = "Correction in progress. Please wait···"
                Descp.isHidden = false
                CorrectView.isHidden = true
                ContentV.isHidden = false
            }
        }
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        dataUpdate()
        SpeakBottomConst.constant = -Dev.screenH
        SpeakCorrectBottom.constant = -Dev.screenH
        CorrectView.isHidden = true
        ErrorLabel.gesture(gesture: .long) { [weak self] dd in
            let paset = UIPasteboard.general
            paset.string = self?.ErrorLabel.text ?? ""
            self?.Alert(message: "Copy successful")
        }
        net = .search
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        actionBtn.isHidden = net == .search
        lottie.play()
        lottie.snp.makeConstraints { make in
            make.left.right.top.bottom.equalToSuperview()
        }
        lottieS.snp.makeConstraints { make in
            make.left.right.bottom.top.equalToSuperview()
        }
        viewModel.correct(data?.content ?? "" ,lessonId: lesssionId ?? 0)
        self.view.setNeedsDisplay()
        DispatchQueue.main.async {
            UIView.animate(withDuration: 0.25) {
                self.SpeakBottomConst.constant = 0
                self.view.layoutIfNeeded()
            }
        }
    }
    
    private func dataUpdate() -> Void {
        viewModel.dateUpdate = {[weak self] data in
            if let b = data as? SpeakEleCorrectModel {
                if !(b.correct?.isEmpty ?? true) {
                    self?.ErrorLabel.text = b.correct
                    self?.ErrorAnyL.text = b.error
                    
                    self?.net = .fail
                    self?.view.layoutIfNeeded()
                    var heigth = self?.SpeakScrollContentV.height ?? 230
                    if heigth > Dev.screenH * 0.7 {
                        heigth = Dev.screenH * 0.7
                    }
                    self?.ScrollHeightConst.constant = heigth
                    self?.view.setNeedsDisplay()
                    UIView.animate(withDuration: 0.25) {
                        self?.SpeakCorrectBottom.constant = 0
                        self?.view.layoutIfNeeded()
                    }
                }else{
                    self?.net = .success
                }
            }
        }
    }
    
    override func viewDidLayoutSubviews() {
        super.viewDidLayoutSubviews()
        self.view.layoutIfNeeded()
        ContentV.cornerRect(radius: 16, [.topLeft,.topRight])
        CorrectView.cornerRect(radius: 16, [.topLeft,.topRight])
        ErrorLabel.cornerRect(radius: 15, [.topLeft,.topRight,.bottomRight])
        ErrorAnyL.cornerRect(radius: 15, [.topLeft,.topRight,.bottomRight])
    }
    
    var data:SpeakDialogueModel?

    @IBAction func CloseTaps(_ sender: Any) {
        self.dismiss(animated: true)
    }
    
    private lazy var lottie: LottieAnimationView = {
        let lott = SpeakLottieObjc.loadLottie("file-searching")
        lott.loopMode = .loop
        ANi.addSubview(lott)
        return lott
    }()
    
    private lazy var lottieS: LottieAnimationView = {
        let lott = SpeakLottieObjc.loadLottie("Succes 1")
        lott.loopMode = .loop
        lott.isHidden = true
        ANi.addSubview(lott)
        return lott
    }()
}


class PaddingLabel: UILabel {
    var padding: UIEdgeInsets = UIEdgeInsets(top: 16, left: 16, bottom: 16, right: 16)
    
    override func drawText(in rect: CGRect) {
        super.drawText(in: rect.inset(by: padding))
    }
    
    override var intrinsicContentSize: CGSize {
        let size = super.intrinsicContentSize
        return CGSize(
            width: size.width + padding.left + padding.right,
            height: size.height + padding.top + padding.bottom
        )
    }
    
    override func sizeThatFits(_ size: CGSize) -> CGSize {
        let adjustedSize = CGSize(
            width: size.width - padding.left - padding.right,
            height: size.height - padding.top - padding.bottom
        )
        let originalSize = super.sizeThatFits(adjustedSize)
        return CGSize(
            width: originalSize.width + padding.left + padding.right,
            height: originalSize.height + padding.top + padding.bottom
        )
    }
}
