//
//  SpeakPublicTipsViewCtr.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/31.
//

import UIKit

class SpeakPublicTipsViewCtr: UIViewController {

    var model:PublicTipsModel?

    // MARK: - ib
    @IBOutlet weak var contentV: UIView!
    @IBOutlet weak var tipsIcon: UIImageView!
    @IBOutlet weak var tipsTitle: UILabel!
    @IBOutlet weak var tipsSubTitle: UILabel!
    @IBOutlet weak var tipsSureBtns: UIButton!
    @IBOutlet weak var tipsCancenBtns: UIButton!
    
    @IBOutlet weak var SpeakBottomConstg: NSLayoutConstraint!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        tipsIcon.image = model?.icon
        tipsTitle.text = model?.title
        tipsSureBtns.setTitle(model?.sureAction, for: .normal)
        tipsCancenBtns.setTitle(model?.cancel, for: .normal)
        if let s:String = model?.descAttr as? String {
            tipsSubTitle.text = s
        }else if let a:NSAttributedString = model?.descAttr as? NSAttributedString {
            tipsSubTitle.attributedText = a
        }
        self.SpeakBottomConstg.constant = -Dev.screenH
    }
    
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        self.view.layoutIfNeeded()
        self.view.setNeedsDisplay()
        DispatchQueue.main.async {
            UIView.animate(withDuration: 0.25) {
                self.SpeakBottomConstg.constant = 0
                self.view.layoutIfNeeded()
            }
        }
    }

    override func touchesBegan(_ touches: Set<UITouch>, with event: UIEvent?) {
        super.touchesBegan(touches, with: event)
        guard let point = touches.first?.location(in: self.view) else { return  }
        if !CGRectContainsPoint(self.contentV.frame, point) {
            self.dismiss(animated: true)
        }
    }
    
    init(configs:PublicTipsModel) {
        self.model = configs
        super.init(nibName: "SpeakPublicTipsViewCtr", bundle: nil)
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    
    @IBAction func tipsSureTaps(_ sender: Any) {
        self.dismiss(animated: true) {
            if let call = self.view.callblack {
                call(true)
            }
        }
    }
    
    @IBAction func tipCancelTaps(_ sender: Any) {
        if let call = self.view.callblack {
            call(false)
        }
        self.dismiss(animated: true)
    }
    
    override func viewDidLayoutSubviews() {
        super.viewDidLayoutSubviews()
        self.view.layoutIfNeeded()
        self.contentV.cornerRect(radius: 16, [.topLeft , .topRight])
    }
    
    func show() -> Void {
        let vc = SpWindow.rootViewController
        self.modalPresentationStyle = .overFullScreen
        self.modalTransitionStyle = .crossDissolve
        vc?.present(self, animated: true)
    }
    
    struct PublicTipsModel {
        var icon:UIImage?
        var title:String?
        var descAttr:Any?
        var sureAction:String?
        var cancel:String?
    }
}
