//
//  SpeakEleRateUsViewCtr.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/24.
//

import UIKit

class SpeakEleRateUsViewCtr: UIViewController {

    @IBOutlet weak var SpeakCenterY: NSLayoutConstraint!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        SpeakCenterY.constant = Dev.screenH
    }

    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        self.view.layoutIfNeeded()
        self.view.setNeedsDisplay()
        DispatchQueue.main.async {
            UIView.animate(withDuration: 0.25) {
                self.SpeakCenterY.constant = 0
                self.view.layoutIfNeeded()
            }
        }
    }
    
    func show() -> Void {
        self.modalPresentationStyle = .overFullScreen
        self.modalTransitionStyle = .crossDissolve
        SpWindow.rootViewController?.present(self, animated: true)
    }
    
    @IBAction func SpeakRateSure(_ sender: Any) {
        guard let url = URL(string: SpeakRateURL) else { return  }
        UIApplication.shared.open(url)
        self.dismiss(animated: true)
    }
    
    @IBAction func SpeakClose(_ sender: Any) {
        self.dismiss(animated: true)
    }
}
