//
//  SpeakEleModifyNameViewCtr.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/24.
//

import UIKit

class SpeakEleModifyNameViewCtr: UIViewController {

    
    @IBOutlet weak var SpeakTextInputText: UITextField!
    @IBOutlet weak var SpeakDashLineV: UIView!
    private let netviewModel = SpeakUserNetViewModel()
    
    @IBOutlet weak var SpeakBottomConst: NSLayoutConstraint!
    @IBOutlet weak var SpeakCenterY: NSLayoutConstraint!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        SpeakBottomConst.constant = Dev.screenH
        SpeakCenterY.constant = Dev.screenH
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        SpeakTextInputText.placeholder = SpeakElePublicManager.share.userInfo.userName
        self.view.setNeedsDisplay()
        DispatchQueue.main.async {
            UIView.animate(withDuration: 0.25) {
                self.SpeakBottomConst.constant = 0
                self.SpeakCenterY.constant = 0
                self.view.layoutIfNeeded()
            }
        }
    }
    
    func show(_ vc:UIViewController?) -> Void {
        self.modalPresentationStyle = .overFullScreen
        self.modalTransitionStyle = .crossDissolve
        vc?.present(self, animated: true)
    }
    
    @IBAction func SpeakRateSure(_ sender: Any) {
        
        let text = SpeakTextInputText.text ?? ""
        if text.isEmpty { return }
        SpeakElePublicManager.share.userInfo.userName = text
        NotificationCenter.default.post(name: Notification.Name.ProfilesettingUpdateUI, object: nil)
        netviewModel.update(param: ["userName":text]) { su in
            if su {
                
            }
        }
        self.dismiss(animated: true)
        
    }
    
    @IBAction func SpeakClose(_ sender: Any) {
        self.dismiss(animated: true)
    }
    
    override func viewDidLayoutSubviews() {
        super.viewDidLayoutSubviews()
        lineV.frame = self.SpeakDashLineV.bounds
        let path = UIBezierPath()
        path.move(to: CGPoint(x: 0, y: self.SpeakDashLineV.bounds.midY))
        path.addLine(to: CGPoint(x: self.SpeakDashLineV.bounds.width, y: self.SpeakDashLineV.bounds.midY))
        lineV.path = path.cgPath
    }
    private lazy var lineV: CAShapeLayer = {
        let shapeLayer = CAShapeLayer()
        shapeLayer.strokeColor = UIColor.init(hex: 0x3980F6).cgColor
        shapeLayer.lineWidth = 2
        shapeLayer.lineDashPattern = [10, 5]
        self.SpeakDashLineV.layer.addSublayer(shapeLayer)
        return shapeLayer
    }()
    
}
