//
//  SpeakEleLearnReViewCtr.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/24.
//

import UIKit

class SpeakEleLearnReViewCtr: UIViewController {

    
    @IBOutlet weak var SpeakEleLearnRemindContentV: UIView!
    @IBOutlet weak var SpeakLearnSwitch: UISwitch!
    @IBOutlet weak var DatePickerView: UIDatePicker!
    @IBOutlet weak var StartReminder: UIButton!
    
    @IBOutlet weak var SpeakBottomConst: NSLayoutConstraint!
    
    
    var isReminder : Bool = false {
        didSet {
            if isReminder == true {
                SpeakLearnSwitch.isOn = SpeakElePublicManager.share.PublicData.isReminder
            }else{
                SpeakLearnSwitch.isOn = false
            }
        }
    }
    override func viewDidLoad() {
        super.viewDidLoad()
        StartReminder.alpha = 0
        SpeakBottomConst.constant = -Dev.screenH
        StartReminder.transform = CGAffineTransformMakeTranslation(0, 10)
        SpeakPermission.checkNotificationPermission {[weak self] su in
            DispatchQueue.main.async {
                self?.isReminder = su
            }
        }
        self.view.gesture(target: self, class: UITapGestureRecognizer.self, selector: #selector(Taps(_:)))
    }

    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        self.view.setNeedsDisplay()
        DispatchQueue.main.async {
            UIView.animate(withDuration: 0.25) {
                self.SpeakBottomConst.constant = 0
                self.view.layoutIfNeeded()
            }
        }
    }
    
    override func viewDidLayoutSubviews() {
        super.viewDidLayoutSubviews()
        self.view.layoutIfNeeded()
        SpeakEleLearnRemindContentV.cornerRect(radius: 16, [.topLeft,.topRight])
    }
    
    
    private func addPush() -> Void {
        if isReminder {
            NotificationManager.scheduleDailyNotification()
        }else{
            NotificationManager.cancelAllNotifications()
        }
    }
    
    @objc private func Taps(_ reg:UIGestureRecognizer) -> Void {
        let p = reg.location(in: self.view)
        if !CGRectContainsPoint(self.SpeakEleLearnRemindContentV.frame, p){
            self.addPush()
            self.dismiss(animated: true)
        }
    }
    
    override func viewDidAppear(_ animated: Bool) {
        super.viewDidAppear(animated)
        UIView.animate(withDuration: 0.35) {
            self.StartReminder.alpha = 1
            self.StartReminder.transform = .identity
        }
    }
    
    func show() -> Void {
        self.modalPresentationStyle = .overFullScreen
        self.modalTransitionStyle = .crossDissolve
        SpWindow.rootViewController?.present(self, animated: true)
    }
    
    @IBAction func SpeakRateSure(_ sender: Any) {
        let date = DatePickerView.date
        let string = date.toStr("hh:mm aa") ?? ""
        SpeakElePublicManager.share.PublicData.MPractice = string
        NotificationCenter.default.post(name: NSNotification.Name.ProfilesettingUpdateUI, object: nil)
        self.addPush()
        self.dismiss(animated: true)
    }
    
    @IBAction func ReminderValueChange(_ sender: UISwitch) {
        if isReminder == false {
            if let url = URL(string: UIApplication.openSettingsURLString) {
                UIApplication.shared.open(url)
            }
        }
    }
}
