//
//  SpeakDialogTipsViewCtr.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/8/19.
//

import UIKit

class SpeakDialogTipsViewCtr: UIViewController {

    @IBOutlet weak var LabelTIBks: UIView!
    
    override func viewDidLoad() {
        super.viewDidLoad()
    }
    
    override func viewDidLayoutSubviews() {
        super.viewDidLayoutSubviews()
        self.view.layoutIfNeeded()
        self.LabelTIBks.layer.sublayers?.filter { $0 is CAGradientLayer }.forEach { $0.removeFromSuperlayer() }
        let gradientLayer = CAGradientLayer()
        gradientLayer.colors = [UIColor.init(hex: 0x92FEC8).cgColor ,UIColor.white.cgColor]
        gradientLayer.startPoint = CGPoint(x: 0.5, y: 0)
        gradientLayer.endPoint = CGPoint(x: 0.5, y: 1)
        gradientLayer.frame = LabelTIBks.bounds
        gradientLayer.cornerRadius = LabelTIBks.height/2.0
        self.LabelTIBks.layer.insertSublayer(gradientLayer, at: 0)
    }
    
    func show() -> Void {
        self.modalPresentationStyle = .overFullScreen
        self.modalTransitionStyle = .crossDissolve
        SpWindow.rootViewController?.present(self, animated: true)
        DispatchQueue.main.asyncAfter(deadline: .now() + 3) {
            self.dismiss(animated: true)
        }
    }
    
}
