//
//  SpeakDialogSenderCell.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/8/5.
//

import UIKit

class SpeakDialogSenderCell: UITableViewCell {

    static let id = "SpeakDialogSenderCell"
    
    @IBOutlet weak var SpeakDialogIcon: UIImageView!
    @IBOutlet weak var SpeakDialogDescp: UILabel!
    
    var leasession:Int?
    
    var data:SpeakDialogueModel? {
        didSet {
            SpeakDialogDescp.text = data?.content
        }
    }
    
    override func awakeFromNib() {
        super.awakeFromNib()
        self.selectionStyle = .none
    }
    
    override func layoutSubviews() {
        super.layoutSubviews()
        if let image = UIImage(named: "sp-guideQA-An") {
            let center = CGPoint(x: image.size.width / 2, y: image.size.height / 2)
            let insets = UIEdgeInsets(
                top: center.y,
                left: center.x,
                bottom: center.y,
                right: center.x
            )
            SpeakDialogIcon.contentMode = .scaleToFill
            SpeakDialogIcon.image = image.resizableImage(withCapInsets: insets, resizingMode: .stretch)
        }
    }

    @IBAction func SpeakRecoverTaps(_ sender: Any) {
        let correct = SpeakEleCorrectViewCtr()
        correct.data =  self.data
        correct.lesssionId = self.leasession
        correct.modalPresentationStyle = .overFullScreen
        correct.modalTransitionStyle = .crossDissolve
        self.responderCtr()?.present(correct, animated: true)
    }
}
