//
//  SpeakDialogLoadingCell.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/8/15.
//

import UIKit

class SpeakDialogLoadingCell: UITableViewCell {

    static let id = "SpeakDialogLoadingCell"
    @IBOutlet weak var SpeakIcon: UIImageView!
    
    @IBOutlet weak var LoadingView: SpeakEleLoading!
    override func awakeFromNib() {
        super.awakeFromNib()
        self.selectionStyle = .none
    }
    
    override func layoutSubviews() {
        super.layoutSubviews()
        if let image = UIImage(named: "sp-guideQA-Qu") {
            let center = CGPoint(x: image.size.width / 2, y: image.size.height / 2)
            let insets = UIEdgeInsets(
                top: center.y,
                left: center.x,
                bottom: center.y,
                right: center.x
            )
            SpeakIcon.contentMode = .scaleToFill
            SpeakIcon.image = image.resizableImage(withCapInsets: insets, resizingMode: .stretch)
        }
    }
}
