//
//  SpeakDialogAIerCell.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/8/6.
//

import UIKit

class SpeakDialogAIerCell: UITableViewCell {

    static let id = "SpeakDialogAIerCell"
    
    @IBOutlet weak var speakBg: UIImageView!
    @IBOutlet weak var SpeakContent: UILabel!
    @IBOutlet weak var SpeakNavtiveL: UILabel!
    
    var isTranslate = false
    
    @IBOutlet weak var SpeakTipsV: UIView!
    @IBOutlet weak var SpeakTipsTitleL: UIButton!
    
    @IBOutlet weak var SpeakLoading: SpeakEleLoading!
    @IBOutlet weak var SpeakPromptL: UILabel!
    
    @IBOutlet weak var SpeakTranslate: UIButton!
    
    var isMute = false
    
    override func awakeFromNib() {
        super.awakeFromNib()
        SpeakTipsTitleL.titleLabel?.numberOfLines = 0
        SpeakTipsV.isHidden = true
        SpeakTipsTitleL.isHidden = true
        SpeakPromptL.gesture(gesture: .long) {[weak self] b in
            let past = UIPasteboard.general
            past.string = self?.SpeakPromptL.text ?? ""
            self?.responderCtr()?.Alert(message: "Copy successful")
        }
    }
    
    var data:SpeakDialogueModel? {
        didSet {
            SpeakContent.text = data?.content
            SpeakTranslate.isSelected = isTranslate
            if isTranslate {
                SpeakNavtiveL.text = data?.translate ?? ""
            }else{
                SpeakNavtiveL.text = ""
            }
            SpeakNavtiveL.isHidden = !(SpeakNavtiveL.text?.count ?? 0 > 0)
            SpeakTipsV.isHidden = !(data?.AniState != SpeakDialogueRoleAnimation.ANone)
            SpeakTipsTitleL.isHidden = SpeakElePublicManager.share.PublicData.isShowDialogTip
            
            if SpeakTipsTitleL.isHidden == false {
                SpeakTipsTitleL.sizeToFit()
                SpeakTipsTitleL.titleLabel?.snp.remakeConstraints { make in
                    make.left.right.top.bottom.equalToSuperview().inset(UIEdgeInsets(top: 8, left: 16, bottom: 12, right: 16))
                }
                SpeakElePublicManager.share.PublicData.isShowDialogTip = true
            }
            SpeakPromptL.text = data?.promptContent
            SpeakLoading.isHidden = (data?.AniState != .loading)
            SpeakPromptL.isHidden = (data?.AniState != .final)
            SpeakContent.sizeToFit()
            self.layoutIfNeeded()
        }
    }
    
    func reload() -> Void {
        if data?.AniState != .ANone {
            SpeakLoading.stopAnimating()
            SpeakLoading.startAnimating()
        }
    }
    
    override func layoutSubviews() {
        super.layoutSubviews()
        if let image = UIImage(named: "sp-guideQA-Qu") {
            let center = CGPoint(x: image.size.width / 2, y: image.size.height / 2)
            let insets = UIEdgeInsets(
                top: center.y,
                left: center.x,
                bottom: center.y,
                right: center.x
            )
            speakBg.contentMode = .scaleToFill
            speakBg.image = image.resizableImage(withCapInsets: insets, resizingMode: .stretch)
        }
    }
    
    /// 播放音频
    @IBAction func SpeakAudioTaps(_ sender: Any) {
        AudioPlayerManager.shared.task = []
        let speed = SpeakElePublicManager.share.PublicData.speed
        if let audio = data?.video {
            let d = AudioPlayerManager.shared.setupAudioPlayer(with: audio ,isMuted: isMute)
            SpeakAIVideoPlayManager.share.PlaySpeak(d/speed)
        }else if let audio = SpeakCache.cache.loadData(fileName: "\(data?.id ?? 0)") {
            let d = AudioPlayerManager.shared.setupAudioPlayer(with: audio ,isMuted:  isMute)
            SpeakAIVideoPlayManager.share.PlaySpeak(d/speed)
        }
    }
    
    /// 翻译
    @IBAction func SpeakTranslateTaps(_ sender: Any) {
        AudioPlayerManager.shared.stop()
        SpeakAIVideoPlayManager.share.PlayBg()
        AudioPlayerManager.shared.task = []
        guard let callblack = callblack else { return }
        callblack(data?.content)
    }
    
    /// 倍速
    @IBAction func SpeakSpeedTaps(_ sender: Any) {
        AudioPlayerManager.shared.task = []
        if let audio = data?.video {
            let d = AudioPlayerManager.shared.setupAudioPlayer(with: audio)
            let db = data?.videoTime ?? 0
            AudioPlayerManager.shared.setupAudioPlayer(with: audio ,isMuted: isMute, rate: 0.5)
            SpeakAIVideoPlayManager.share.PlaySpeak(db/0.5)
        }else if let audio = SpeakCache.cache.loadData(fileName: "\(data?.id ?? 0)") {
            let d = AudioPlayerManager.shared.setupAudioPlayer(with: audio)
            AudioPlayerManager.shared.setupAudioPlayer(with: audio ,isMuted: isMute, rate: 0.5)
            SpeakAIVideoPlayManager.share.PlaySpeak(d/0.5)
        }
    }
    
    
    deinit {
        SpeakLoading.stopAnimating()
        callblack = nil
    }
}
