//
//  SpeakDialogAIReviewCell.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/8/26.
//

import UIKit

class SpeakDialogAIReviewCell: UITableViewCell {

    static let id = "SpeakDialogAIReviewCell"
    
    @IBOutlet weak var SpeakDialogDescp: UILabel!
    @IBOutlet weak var SpeakDialogIcont: UIImageView!
    
    
    var data:SpeakDialogueModel? {
        didSet {
            SpeakDialogDescp.text = data?.content
        }
    }
    
    override func awakeFromNib() {
        super.awakeFromNib()
    }
    
    override func layoutSubviews() {
        super.layoutSubviews()
        if let image = UIImage(named: "sp-guideQA-Qu") {
            let center = CGPoint(x: image.size.width / 2, y: image.size.height / 2)
            let insets = UIEdgeInsets(
                top: center.y,
                left: center.x,
                bottom: center.y,
                right: center.x
            )
            SpeakDialogIcont.contentMode = .scaleToFill
            SpeakDialogIcont.image = image.resizableImage(withCapInsets: insets, resizingMode: .stretch)
        }
    }
}
