//
//  SpeakDialogueModel.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/8/6.
//

import UIKit


enum SpeakDialogueRole : String , Codable{
    case AI = "assistant"
    case User = "user"
    case loading = "loading"
    case review = "review"
    case AIReview = "AIReview"
}


enum SpeakDialogueRoleAnimation : Int , Codable{
    case loading = 10
    case final = 11
    case ANone = 12
}

struct SpeakDialogueModel: Codable {
    var id:Int?
    var userId:Int?
    var courseId:Int?
    var createdAt:String?
    var content:String?
    var role:SpeakDialogueRole?
    var video:Data?//String?
    var videoTime:Double?
    var translate:String?
    var AniState:SpeakDialogueRoleAnimation? = .ANone
    var promptContent:String?
    var recordId:Int?
    var isLearningCompleted:Bool?
    var isPractiseCompleted:Bool?
    var firstLearnCompleted:Bool?
    var learnedVocabulary:Int?
}

struct SpeakdialogueTalkModel : Codable {
    var isLearningCompleted:Bool?
    var isPractiseCompleted:Bool?
    var firstLearnCompleted:Bool?
    var learnedVocabulary:Int?
    var contentList:[SpeakDialogueModel]?
    var requiresUserResponse:Bool?
    var promptContent:String?
}
