//
//  SpeakDialogueSetViewCtr.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/8/6.
//

import UIKit

class SpeakDialogueSetViewCtr: UIViewController {

    
    @IBOutlet weak var SpeakDialogContentV: UIView!
    @IBOutlet weak var SpeakDialogSetSw: UISwitch!
    @IBOutlet var SpeakDialogSpeeds: [UIButton]!
    
    @IBOutlet weak var SpeakSmartV: UIView!
    
    @IBOutlet weak var SpeakBottomConst: NSLayoutConstraint!
    
    
    var callblock:((Bool)->Void)?
    
    override func viewDidLoad() {
        super.viewDidLoad()
        var tag = 2
        SpeakBottomConst.constant = -Dev.screenH
        SpeakDialogSpeeds.forEach { speed in
            speed.tag = tag
            speed.setBackgroundImage(UIColor.init(hex: 0x000000,alpha: 0.08).generate(), for: .normal)
            speed.setBackgroundImage(UIColor.init(hex: 0x3980F6,alpha: 0.08).generate(), for: .selected)
            speed.isSelected = ((CGFloat(tag) * 0.25) == SpeakElePublicManager.share.PublicData.speed)
            tag += 1
            speed.corners = speed.height/2.0
            speed.addTarget(self, action: #selector(speedTaps(_:)), for: .touchUpInside)
        }
        SpeakDialogSetSw.isOn = SpeakElePublicManager.share.PublicData.Smarttips
    }

    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        self.view.setNeedsDisplay()
        DispatchQueue.main.async {
            UIView.animate(withDuration: 0.25) {
                self.SpeakBottomConst.constant = 0
                self.view.layoutIfNeeded()
            }
        }
    }
    
    override func viewDidLayoutSubviews() {
        super.viewDidLayoutSubviews()
        SpeakDialogContentV.cornerRect(radius: 16, [.topLeft,.topRight])
        SpeakSmartV.shadow(cornerRadius: 8, shadowColor: .init(hex: 0x000000,alpha: 0.08), offset: CGSizeMake(0, 2), opacity: 1, radius: 10)
    }
    
    func show( complate:@escaping ((Bool)->Void)) -> Void {
        self.modalPresentationStyle = .overFullScreen
        self.modalTransitionStyle = .crossDissolve
        callblock = complate
        SpWindow.rootViewController?.present(self, animated: true)
    }
    
    @IBAction func SpeakDialogSetValueChange(_ sender: UISwitch) {
        SpeakElePublicManager.share.PublicData.Smarttips = sender.isOn
    }
    
    @objc private func speedTaps(_ sender:UIButton) -> Void {
        if !sender.isSelected {
            SpeakDialogSpeeds.forEach({$0.isSelected = ($0 == sender) })
            SpeakElePublicManager.share.PublicData.speed = (0.25 * Double(sender.tag))
        }
    }
    
    @IBAction func SpeakDialogCloseTaps(_ sender: Any) {
        if let call = callblock {
            call(false)
        }
        self.dismiss(animated: true)
    }
    
    @IBAction func SpeakDialogRestartTaps(_ sender: Any) {
        guard let call = callblock else { return }
        self.dismiss(animated: true) {
            call(true)
        }
//        SpeakElePublicManager.share.PublicData.Smarttips = true
//        SpeakDialogSetSw.isOn = true
//        SpeakElePublicManager.share.PublicData.speed = 1
//        var tag = 2
//        SpeakDialogSpeeds.forEach { speed in
//            speed.isSelected = ((CGFloat(tag) * 0.25) == SpeakElePublicManager.share.PublicData.speed)
//            tag += 1
//        }
    }
    
    deinit {
        callblock = nil
    }
    
}
