//
//  SpeakSnowTypeViewCtr.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/8/1.
//

import UIKit

class SpeakSnowTypeViewCtr: UIViewController {

    
    @IBOutlet weak var SpeakSnowTitleL: UILabel!
    @IBOutlet weak var SpeakSnowIcon: UIImageView!
    @IBOutlet weak var SpeakSnowDescpL: UILabel!
    
    @IBOutlet weak var SpeakSnowSuccess: UIStackView!
    @IBOutlet weak var SpeakSnowFailView: UIView!
    @IBOutlet weak var SpeakSnowGetBtns: UIButton!
    
    @IBOutlet weak var SpeakBottomConst: NSLayoutConstraint!
    
    var state:Int = 0
    
    init(state:Int) {
        self.state = state
        super.init(nibName: "SpeakSnowTypeViewCtr", bundle: nil)
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        SpeakBottomConst.constant = Dev.screenH
        setup()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        self.view.setNeedsLayout()
        DispatchQueue.main.async {
            UIView.animate(withDuration: 0.25) {
                self.SpeakBottomConst.constant = 0
                self.view.layoutIfNeeded()
            }
        }
    }

    override func touchesBegan(_ touches: Set<UITouch>, with event: UIEvent?) {
        
    }
    
    private func setup() -> Void {
        SpeakSnowGetBtns.semanticContentAttribute = .forceRightToLeft
        SpeakSnowSuccess.isHidden = state == 0
        SpeakSnowFailView.isHidden = state != 0
        if state == 0 {
            SpeakSnowTitleL.text = "Fail"
            SpeakSnowIcon.image = UIImage(named: "icon_snow_off")
            SpeakSnowDescpL.text = "Not enough snowflakes"
        }else{
            SpeakSnowTitleL.text = "snowflake"
            SpeakSnowIcon.image = UIImage(named: "icon_snow_on")
            SpeakSnowDescpL.text = "Every monthly 3/7/14-day streaks"
//            DispatchQueue.main.asyncAfter(deadline: .now() + 2.5) {
//                self.Close(0)
//            }
        }
    }

    @IBAction func SpeakSnowTypeGet(_ sender: Any) {
        self.Close(1)
    }
    
    @IBAction func SpeakSnowClose(_ sender: Any) {
        self.Close(0)
    }
    
    private func Close(_ index:Int) -> Void {
        guard let call = self.view.callblack else { return }
        call( (index != 0 && self.state == 0) )
    }
    
}
