//
//  SpeakEndorViewCtr.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/8/1.
//

import UIKit

class SpeakEndorViewCtr: UIViewController {

    @IBOutlet weak var ContentView: UIView!
    @IBOutlet weak var SpeakBottomConst: NSLayoutConstraint!
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        SpeakBottomConst.constant = -Dev.screenH
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        self.view.setNeedsDisplay()
        DispatchQueue.main.async {
            UIView.animate(withDuration: 0.25) {
                self.SpeakBottomConst.constant = 0
                self.view.layoutIfNeeded()
            }
        }
    }
    
    override func touchesBegan(_ touches: Set<UITouch>, with event: UIEvent?) {
        guard let p = touches.first?.location(in: self.view) else { return }
        if !CGRectContainsPoint(self.ContentView.frame, p) {
            self.dismiss(animated: true)
        }
    }

    override func viewDidLayoutSubviews() {
        super.viewDidLayoutSubviews()
        self.view.layoutIfNeeded()
        ContentView.cornerRect(radius: 16, [.topLeft,.topRight])
    }
    
    @IBAction func SpeakEndorSureTaps(_ sender: Any) {
        guard let call = self.view.callblack else { return }
        call(true)
    }
    
    @IBAction func SpeakEndorCancelTaps(_ sender: Any) {
        self.dismiss(animated: true)
    }
}
