//
//  SpeakEleSignTipsViewCtr.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/8/4.
//

import UIKit

class SpeakEleSignTipsViewCtr: SpeakEleBaseViewCtr {

    
    @IBOutlet weak var SpeakSignAnimationV: UIImageView!
    @IBOutlet weak var SignNum: UILabel!
    @IBOutlet var SpeakWeekTLS: [UILabel]!
    @IBOutlet var SpeakWeekSigns: [UIButton]!
    
    
    @IBOutlet weak var SpeakDescptionL: UILabel!
    @IBOutlet weak var SpeakWeeksView: UIView!
    
    @IBOutlet weak var SpeakAnimation: UILabel!
    
    
    let week:[String] = ["Sun" ,"Mon" ,"Tue" ,"Wed" ,"Thu" ,"Fri" ,"Sat"]
    
    private var dayOfWeek:[String] = []
    
    override func viewDidLoad() {
        super.viewDidLoad()
        for (i,v) in week.enumerated() {
            SpeakWeekTLS[i].adjustsFontSizeToFitWidth = true
            SpeakWeekTLS[i].text = v
        }
        SpeakWeekSigns.forEach({$0.isSelected = true})
        
        let set = NSMutableSet()
        let bd = speakSignListViewModel.share.signList ?? [:]
        for v in bd.values {
            for day in v {
                set.add(day.signDate)
            }
        }
        let week = Date().dayOfWeekInt()
        let date = Date().operation(day: -(week))
        for i in 1...7 {
            let ds = date.operation(day: i).toStr("yyyy-MM-dd") ?? ""
            dayOfWeek.append(ds)
            let has = set.contains(ds)
            SpeakWeekSigns[i-1].isSelected = !has
            Print(ds)
        }
        SignNum.font = UIFont.montserrat(.YouSheBiao,size: 92)
        SpeakAnimation.font = SignNum.font
        SignNum.textColor = .white
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        titleView.isHidden = true
        SignNum.textBorder(width: 4, color: .init(hex: 0xFF7700))
    }
    
    override func viewDidAppear(_ animated: Bool) {
        super.viewDidAppear(animated)
        self.toAnimation()
    }
    
    private func toAnimation() -> Void {
        UIView.animate(withDuration: 0.4) {
            self.SpeakAnimation.transform = CGAffineTransformMakeTranslation(0, 50)
            self.SpeakAnimation.alpha = 0
        }
        UIView.animate(withDuration: 0.3 ,delay: 0.2) {
            self.SignNum.alpha = 1
            self.SpeakSignAnimationV.alpha = 1
        }
        SpeakSignAnimationV.loadGif(name: "火焰_00000_iSpt",oftype: "png",repeatCount: 0)
        UIView.animate(withDuration: 0.23 ,delay: 0.5) {
            self.SpeakDescptionL.alpha = 1
            self.SpeakWeeksView.alpha = 1
        }
    }
    
    override func setup() -> Void {
        let bd = speakSignListViewModel.share.signList ?? [:]
        var count = 0
        for v in bd.values {
            count += v.count
        }
        SignNum.text = "\(count)"
        SpeakAnimation.text = "\(count-1)"
    }
    
    func alert() -> Void {
        self.modalPresentationStyle = .fullScreen
        SpWindow.rootViewController?.present(self, animated: true)
    }
    
    @IBAction func SpeakContinueTaps(_ sender: Any) {
        self.dismiss(animated: true)
    }
}
