//
//  SpeakEleSendCodeAlert.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/14.
//

import UIKit
import Lottie

class SpeakEleSendCodeAlert: UIView {

    @IBOutlet weak var TopAnimationV: UIView!
    
    class func xib() -> SpeakEleSendCodeAlert {
        let nib = UINib(nibName: "SpeakEleSendCodeAlert", bundle: nil).instantiate(withOwner: nil).first as! SpeakEleSendCodeAlert
        nib.alpha = 0
        return nib
    }

    override func awakeFromNib() {
        super.awakeFromNib()
        TopAnimationV.addSubview(lottie)
        lottie.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.centerY.equalToSuperview()
            make.height.equalTo(lottie.snp.width).multipliedBy(48.0/150)
            make.width.equalTo(512)
        }
    }
    
    func show() -> Void {
        SpWindow.addSubview(self)
        self.frame = SpWindow.bounds
        UIView.animate(withDuration: 0.2) {
            self.alpha = 1
        } completion: { su in
            if su {
                self.lottie.play()
            }
        }
    }
    
    func hide() -> Void {
        UIView.animate(withDuration: 0.1) {
            self.alpha = 0
        } completion: { su in
            if su {
                self.removeFromSuperview()
            }
        }
    }
    
    private lazy var lottie: LottieAnimationView = {
        let lott = SpeakLottieObjc.loadLottie("SendEmailCode")
        lott.loopMode = .playOnce
        return lott
    }()
}

