//
//  UserResponseModel.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/21.
//

import UIKit

struct UserMode:Codable {
    var id:Int?
    /// 用户名
    var userName:String?
    var appleUserId:String?
    var googleUserId:String?
    
    var email:String?
    var status:Int?
    var avatar:String?
    /// 母语
    var nativeLanguage:String?
    var subscribed:Int?
    /// 等级
    var targetLevel:Int?
    var targetLanguage:String? = "🇬🇧 English"
    var type:Int?
    var token:String?
    /// 是否用母语学习
    var learnedNative:Int?
    /// 雪花
    var snowNum:Int?
    /// 最大签到
    var maxContinuousSignDays:Int?
    /// 当前签到
    var currentContinuousSignDays:Int?
    /// 是否新用户
    var newUser:Bool?
    
    func isLogin() -> Bool {
        return (self.token?.count ?? 0 > 0)
    }
    
    static let keyPathMap: [String: PartialKeyPath<UserMode>] = [
            "id": \UserMode.id,
            "userName": \UserMode.userName,
            "appleUserId": \UserMode.appleUserId,
            "googleUserId": \UserMode.googleUserId,
            "email": \UserMode.email,
            "status": \UserMode.status,
            "avatar": \UserMode.avatar,
            "nativeLanguage": \UserMode.nativeLanguage,
            "subscribed": \UserMode.subscribed,
            "targetLevel": \UserMode.targetLevel,
            "type": \UserMode.type,
            "token": \UserMode.token,
            "learnedNative": \UserMode.learnedNative,
            "snowNum": \UserMode.snowNum,
            "maxContinuousSignDays": \UserMode.maxContinuousSignDays,
            "currentContinuousSignDays":\UserMode.currentContinuousSignDays,
            "newUser":\UserMode.newUser
        ]
    
    mutating func assign(from source: UserMode?) {
        for (_, keyPath) in UserMode.keyPathMap {
            switch keyPath {
            case let keyPath as WritableKeyPath<UserMode, Int?>:
                if self[keyPath: keyPath] == nil, let value = source?[keyPath: keyPath] {
                    self[keyPath: keyPath] = value
                }
            case let keyPath as WritableKeyPath<UserMode, String?>:
                if self[keyPath: keyPath] == nil, let value = source?[keyPath: keyPath] {
                    self[keyPath: keyPath] = value
                }
            default:
                break
            }
        }
    }
}

