//
//  SpeakEleLoginGuideCtr.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/10.
//

import UIKit


class SpeakEleLoginGuideCtr: SpeakEleBaseViewCtr {

    @IBOutlet weak var SpeakDescLabel: UILabel!
    
    @IBOutlet weak var TopIcon: UIImageView!
    
    @IBOutlet weak var ShowTopImg: UIImageView!
    
    @IBOutlet weak var ShowAniM1: UIImageView!
    
    @IBOutlet weak var ShowAniM2: UIImageView!
    
    @IBOutlet weak var ShowButtons: UIStackView!
    
    
    @IBOutlet weak var centerBottonConst: NSLayoutConstraint!
    
    @IBOutlet weak var TopWidthConst: NSLayoutConstraint!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        self.startAni()
    }

    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        setDescription()
    }
    
    private func startAni() -> Void {
        self.TopIcon.alpha = 1
        ShowButtons.alpha = 0
        ShowTopImg.alpha = 0
        ShowAniM1.alpha = 1
        self.ShowAniM1.isHidden = true
        ShowAniM2.alpha = 0
        TopWidthConst.constant = 302 * 2.0
        ShowAniM2.alpha = 0
        
        self.ShowButtons.alpha = 0
        centerBottonConst.constant = 150
        self.view.layoutIfNeeded()
        DispatchQueue.main.async {
            self.view.setNeedsDisplay()
            UIView.animate(withDuration: 0.5) {
                self.TopIcon.alpha = 0.0
            } completion: { su in
                if su {
                    self.ShowAniM1.isHidden = false
                    UIView.animate(withDuration: 0.6) {
                        self.ShowAniM1.alpha = 1
                        self.TopWidthConst.constant = 302 * 1.2
                        self.view.layoutIfNeeded()
                    } completion: { su in
                        if su {
                            UIView.animate(withDuration: 0.6) {
                                self.ShowAniM2.alpha = 1
                                self.ShowButtons.alpha = 1
                                self.TopWidthConst.constant = 302
                                self.ShowTopImg.alpha = 1
                                self.centerBottonConst.constant = 80
                                self.view.layoutIfNeeded()
                            } completion: { su in
    
                            }
                        }
                    }
                }
            }
        }
    }
    
    override func viewDidLayoutSubviews() {
        super.viewDidLayoutSubviews()
    }
    
    @IBAction func SpeakLogin(_ sender: Any) {
        let login = SpeakEleLoginViewCtr()
        self.navigationController?.pushViewController(login, animated: true)
    }
    
    @IBAction func SpeakSkip(_ sender: Any) {
        let guide = SpeakEleGuideViewCtr()
        self.navigationController?.pushViewController(guide, animated: true)
    }
    
    private func TermsOfService() -> Void {
        let web = SpeakEleWebViewCtr()
        web.LoadWithUrl(url: SpeakTerms)
        self.navigationController?.pushViewController(web, animated: true)
    }
    
    private func PrivacyPolicy() -> Void {
        let web = SpeakEleWebViewCtr()
        web.LoadWithUrl(url: SpeakPrivacy)
        self.navigationController?.pushViewController(web, animated: true)
    }
    
    private func setDescription() -> Void {
//        SpeakDescLabel.AddTextTap(["Privacy Policy","Terms of Service."])
        let privacy = "Privacy Policy".attributed().font(UIFont.montserrat(.medium,size: 10)).underline(.single).paragraphStyle(.center,lineSpacing: 4).build()
        let terms = "Terms of Service.".attributed().font(UIFont.montserrat(.medium,size: 10)).underline(.single).paragraphStyle(.center,lineSpacing: 4).build()
        let att = "Proceeding further indicates your agreement to our ".attributed().paragraphStyle(.center,lineSpacing: 4).build().combined(with: [privacy,"\nand ", terms])
        SpeakDescLabel.attributedText = att
        let tap = UITapGestureRecognizer(target: self, action: #selector(tapClick(_:)))
        SpeakDescLabel.isUserInteractionEnabled = true
        SpeakDescLabel.addGestureRecognizer(tap)
//        SpeakDescLabel.callblack = { [weak self] text in
//            guard let v:String = text as? String else { return }
//            if v == "Privacy Policy" {
//                self?.PrivacyPolicy()
//            }else{
//                self?.TermsOfService()
//            }
//        }

    }
    
    @objc private func tapClick(_ res:UIGestureRecognizer) -> Void {
        let Point = res.location(in: self.SpeakDescLabel)
        Print(Point)
        self.view.layoutIfNeeded()
        let height = self.SpeakDescLabel.height
        if Point.y > height/2.0 {
            var min = SpeakDescLabel.width / 2.0
            min -= 35
            let max = min + 70
            if Point.x > min && Point.x < max {
                self.TermsOfService()
            }
        }else{
            let min = SpeakDescLabel.width - 80
            let max = SpeakDescLabel.width
            if Point.x > min && Point.x < max {
                self.PrivacyPolicy()
            }
        }
    }
}
