//
//  SpeakEleForgetViewCtr.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/14.
//

import UIKit

class SpeakEleForgetViewCtr: SpeakEleBaseViewCtr {

    // MARK: - ib

    @IBOutlet weak var SpeakEmailTextField: UITextField!
    @IBOutlet weak var SpeakSendCodeBtn: SpeakEleButton!
    
    private let viewModel = SpeakUserNetViewModel()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        SpeakEmailTextField.delegate = self
    }

    @IBAction func SpeakSendCode(_ sender: Any) {
        if (SpeakEmailTextField.text ?? "").isValidEmail() {
            viewModel.forgot(param: ["email":SpeakEmailTextField.text ?? ""]) { [weak self] success in
                if success {
                    self?.SpeakEmailTextField.text = ""
                    let alert = SpeakEleSendCodeAlert.xib()
                    alert.show()
                    DispatchQueue.main.asyncAfter(deadline: .now() + 2.5) {
                        alert.hide()
                    }
                }
            }

            
        }else{
            Alert(message: "Please enter the correct email address")
        }
    }
    
}

extension SpeakEleForgetViewCtr : UITextFieldDelegate {
    
    func textFieldDidChangeSelection(_ textField: UITextField) {
        let text = textField.text ?? ""
        SpeakSendCodeBtn.isEnabled = !text.isEmpty
    }
    
}
