//
//  SpeakEleFLoginViewCtr.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/17.
//

import UIKit

class SpeakEleFLoginViewCtr: SpeakEleBaseViewCtr {

    // MARK: - ib
    @IBOutlet var LoginBtns: [UIButton]!
    
    private let viewModel = SpeakEleLoginViewModel()
    private let net = SpeakUserNetViewModel()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        SpeakElePublicManager.share.PublicData.state = .login
        self.navigationController?.interactivePopGestureRecognizer?.isEnabled = false
        
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        titleView.isHidden = true
        self.view.layoutIfNeeded()
        var idx = 0
        LoginBtns.forEach { btn in
            if idx == 0 {
                btn.setBackgroundImage(UIColor.black.generate(btn.size,20), for: .normal)
                btn.setBackgroundImage(UIColor.black.generate(btn.size,20), for: .highlighted)
            }else{
                btn.setBackgroundImage(UIColor.white.generate(btn.size,20), for: .normal)
                btn.setBackgroundImage(UIColor.init(hex: 0x191919).generate(btn.size,20), for: .highlighted)
            }
            btn.clipsToBounds = false
            idx += 1
        }
    }

    override func viewDidLayoutSubviews() {
        super.viewDidLayoutSubviews()
        self.view.layoutIfNeeded()
        LoginBtns.forEach { btn in
            btn.shadow(cornerRadius: 20,shadowColor: .init(hex: 0x000000,alpha: 0.06),offset: CGSize(width: 0, height: 2) ,opacity: 1,radius: 5)
        }
    }
    
    @IBAction func LoginBtnTaps(_ sender: UIButton) {
        if sender == LoginBtns[0] {
            viewModel.AppleLogin { response in
                switch response {
                case .success(let token):
                    self.net.logion(param: ["appleUserId":token,
                                            "type":1,
                                            "isLogin":true]) { [weak self] (succsee, data:UserMode?) in
                        if succsee {
                            SpeakElePublicManager.share.userInfo.assign(from: data)
                            self?.ToHome()
                        }
                    }
                    break
                case .failure(let error):
                    self.Alert(message: "Login failed")
                    break
                }
            }
        }else if sender == LoginBtns[1] {
            viewModel.googleLogin { response in
                switch response {
                case .success(let token):
                    self.net.logion(param: ["googleUserId":token,
                                            "type":2,
                                            "isLogin":true]) { [weak self] (succsee, data:UserMode?) in
                        if succsee {
                            SpeakElePublicManager.share.userInfo.assign(from: data)
                            self?.ToHome()
                        }
                    }
                    break
                case .failure(let error):
                    self.Alert(message: "Login failed")
                    break
                }
            }
        }else{
            let vc = SpeakEleLoginViewCtr()
            vc.state = .register
            self.navigationController?.pushViewController(vc, animated: true)
        }
    }
    
    @IBAction func EmailLoginTaps(_ sender: UIButton) {
        let vc = SpeakEleLoginViewCtr()
        self.navigationController?.pushViewController(vc, animated: true)
    }
    
    private func ToHome() -> Void {
        
        updateUserInformation()
        let nav = SpeakEleBaseNavigationCtr(rootViewController: SpeakEleTabbarViewCtr())
        SpWindow.switchToController(nav)
        
    }
}
