//
//  SpeakEleLaunchViewCtr.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/10.
//

import UIKit

class SpeakEleLaunchViewCtr: SpeakEleBaseViewCtr {

    override func viewDidLoad() {
        super.viewDidLoad()
        DispatchQueue.main.asyncAfter(deadline: .now() + 0.01) {
            self.ToPages()
        }
    }
    
    private func ToPages() -> Void {
        
        switch SpeakElePublicManager.share.PublicData.state {
        case .start:
            if SpeakElePublicManager.share.userInfo.isLogin() {
                let guide = SpeakEleGuideViewCtr()
                let nav = SpeakEleBaseNavigationCtr(rootViewController: guide)
                SpWindow.switchToController(nav)
            }else{
                let nav = SpeakEleBaseNavigationCtr(rootViewController: SpeakEleLoginGuideCtr())
                SpWindow.rootViewController = nav
            }
            break
        case .subscribe:
            let sub = SpeakEleIAPViewCtr()
            sub.state = .guide
            let nav = SpeakEleBaseNavigationCtr(rootViewController: sub)
            SpWindow.switchToController(nav)
        case .qanda:
            let nav = SpeakEleBaseNavigationCtr(rootViewController: SpeakEleQAViewCtr())
            SpWindow.switchToController(nav)
        case .login:
            let nav = SpeakEleBaseNavigationCtr(rootViewController: SpeakEleFLoginViewCtr())
            SpWindow.switchToController(nav)
            break
        default:
            let nav = SpeakEleBaseNavigationCtr(rootViewController: SpeakEleTabbarViewCtr())
            SpWindow.switchToController(nav)
            break
        }
        
    }

}
