//
//  SpeakIAPConfigs.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/9/8.
//

import UIKit

class SpeakIAPConfigs: NSObject {

    static let share = SpeakIAPConfigs()
    private let userdefKey = "IAPConfigsModel"
    private let viewModel = SpeakUserNetViewModel()
    
    var configs:IAPConfigsModel = IAPConfigsModel()
    
    func loadData() -> Void {
        let data = UserDefaults.standard.object(forKey: userdefKey) as? Data
        do{
            let figs = try JSONDecoder().decode(IAPConfigsModel.self, from: data ?? Data())
            self.configs = figs
        }catch{
            do{
                let data = "SpeakConfigsData".loadData() ?? Data()
                let CData = try JSONDecoder().decode(IAPConfigsModel.self, from: data)
                self.configs = CData
            }catch{ }
        }
        self.viewModel.SpeakIapConfigs { [weak self] data in
            if let data = data {
                self?.configs = data
                do{
                    let save = try JSONEncoder().encode(data)
                    UserDefaults.standard.set(save, forKey: self?.userdefKey ?? "")
                }catch{}
            }
        }
    }
 
    private override init() { }
}


struct IAPConfigsModel:Codable {
    var SpeakPayTL:IAPConfigsDModel?
    var SpeakPayTR:IAPConfigsDModel?
    var SpeakPayTHint:IAPConfigsDModel?
    var SpeakPayBL:IAPConfigsDModel?
    var SpeakPayBR:IAPConfigsDModel?
    var SpeakPayBHint:IAPConfigsDModel?
}
struct IAPConfigsDModel:Codable {
    var color:String?
    var font:String?
}
