//
//  SpeakEleQAViewModel.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/11.
//

import UIKit

class SpeakEleQAViewModel: NSObject {

    var anwerUpdate:(()->Void)?
    var SpeakLanguages:[String] = []
    var SpeakHoby:[String] = []
    
    var anwer:[SpeakEleQAModel] = [] {
        didSet {
            if let anwerUpdate = anwerUpdate {
                anwerUpdate()
            }
            SaveData(anwer)
        }
    }
    
    func fetchData() -> Void {
        let data = UserDefaults.standard.object(forKey: UnsafeRawUserDefaultsKey.UnsafeGuideQAKey.rawValue) as? Data ?? Data()
        do {
            anwer = try JSONDecoder().decode([SpeakEleQAModel].self, from: data)
        }catch {
            anwer = []
        }
        do {
            let data = "SpeakGuideQandALanguage".loadData() ?? Data()
            let ds = try JSONDecoder().decode([String].self, from: data)
            SpeakLanguages = ds
        }catch{}
        do {
            let data = "SpeakGuideQandAHoby".loadData() ?? Data()
            let hoby = try JSONDecoder().decode([String].self, from: data)
            SpeakHoby = hoby
        }catch{}
    }
    
     func SaveData(_ data:[SpeakEleQAModel]) -> Void {
        do {
            let data = try JSONEncoder().encode(data)
            UserDefaults.standard.setValue(data, forKey: UnsafeRawUserDefaultsKey.UnsafeGuideQAKey.rawValue)
            UserDefaults.standard.synchronize()
        }catch{ }
    }
    
    var questionArrys:[SpeakEleQAModel] {
        get {
            return [
                SpeakEleQAModel(speakMsg: "Hello! I’m Speakly, an AI tutor designed just for you. I’m here to assist with boosting your English skills." ),
                SpeakEleQAModel(speakMsg: "May I know your name?" ,messageType: .name),
                SpeakEleQAModel(speakMsg: "" ,role: .speakUser ,messageType: .name),
                
                SpeakEleQAModel(speakMsg: "Nice to make your acquaintance, $$$N !"),
                SpeakEleQAModel(speakMsg: "I have a few questions to help me get a better sense of you."),
                SpeakEleQAModel(speakMsg: "What language do you speak natively?",messageType: .language),
                SpeakEleQAModel(speakMsg: "",role: .speakUser,messageType: .language),
                
                SpeakEleQAModel(speakMsg: "Would you prefer English lessons with explanations in $$$L or in English itself?",messageType: .like),
                SpeakEleQAModel(speakMsg: "",role: .speakUser,messageType: .like),
                
                SpeakEleQAModel(speakMsg: "Go ahead and pick your interests. You can select a maximum of 4 choices." , messageType: .hobby),
                SpeakEleQAModel(speakMsg: "" ,role: .speakUser , messageType: .hobby),
                
                SpeakEleQAModel(speakMsg: "Which aspects of English do you want to work on improving?",messageType: .improving),
                SpeakEleQAModel(speakMsg: "" ,role: .speakUser ,messageType: .improving),
                
                
                SpeakEleQAModel(speakMsg: "How would you describe your current English proficiency?",messageType: .proficiency),
                SpeakEleQAModel(speakMsg: "" ,role: .speakUser ,messageType: .proficiency),
                
                SpeakEleQAModel(speakMsg: "How soon do you hope to achieve your English learning goals?",messageType: .goalDays),
                SpeakEleQAModel(speakMsg: "" ,role: .speakUser ,messageType: .goalDays),
                
                SpeakEleQAModel(speakMsg: "What’s your daily target for practice?",messageType: .studytime),
                SpeakEleQAModel(speakMsg: "" ,role: .speakUser ,messageType: .studytime),
                
                SpeakEleQAModel(speakMsg: "Choose a specific time each day when you’d like to start your practice sessions.",messageType: .practice),
                SpeakEleQAModel(speakMsg: "" ,role: .speakUser ,messageType: .practice),
                
                SpeakEleQAModel(speakMsg: "I’ll send you a reminder for your practice time every day. To ensure you don’t skip a session, please enable notifications!", messageType: .finish)
            ]
        }
    }
    
    var improving:[String] {
        set {}
        get{
            return ["Vocabulary",
                    "Grammar",
                    "Pronunciation",
                    "Listening",
                    "Speaking"]
        }
    }
    
    var proficiency:[String] {
        set {}
        get {
            return ["Entry-level",
                    "Lower-intermediate",
                    "Mid-level",
                    "Upper-mid",
                    "High-advanced",
                    "Expert-level"]
        }
    }
    
    var goalDays:[String] {
        set {}
        get {
            return ["15days","30days","45days","60days"]
        }
    }
    
    var studyTime:[String] {
        set{}
        get {
            return ["10min/day" ,"15min/day" ,"30min/day" ,"45min/day","60min/day"]
        }
    }
}
