//
//  SpeakEleTranSCell.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/17.
//

import UIKit

class SpeakEleTranSCell: SpeakEleQABaseViewCell {

    static let id = "SpeakEleTranSCell"
    
    override func setup() {
        bgView.snp.makeConstraints { make in
            make.left.right.bottom.top.equalToSuperview().inset(UIEdgeInsets(top: -10, left: -10, bottom: -10, right: -10))
        }
        self.titleL.snp.makeConstraints { make in
            make.left.top.right.equalToSuperview().inset(16)
            make.width.lessThanOrEqualTo(Dev.screenW * 0.7)
            make.width.greaterThanOrEqualTo(20)
            make.height.greaterThanOrEqualTo(20)
        }
        self.lineV.snp.makeConstraints { make in
            make.left.right.equalToSuperview().inset(16)
            make.top.equalTo(self.titleL.snp.bottom).offset(16)
            make.height.equalTo(0.6)
        }
        self.stack.snp.makeConstraints { make in
            make.left.equalToSuperview().inset(16)
            make.top.equalTo(self.lineV.snp.bottom).offset(16)
        }
        self.transLabel.snp.makeConstraints { make in
            make.left.right.equalToSuperview().inset(16)
            make.top.equalTo(self.stack.snp.bottom).offset(10)
            make.bottom.equalToSuperview().inset(16)
            make.height.greaterThanOrEqualTo(0)
        }
        contentV.snp.makeConstraints { make in
            make.right.top.bottom.equalToSuperview().inset(UIEdgeInsets(top: 2, left: 0, bottom: 16, right: (marginLR)))
            make.width.equalTo(Dev.screenW * 0.6 )
        }
    }
    
    override var data:SpeakEleQAModel? {
        didSet {
            bgView.type = data?.role ?? .speakAI
            
            var title = data?.speakMsg.replacingOccurrences(of: "$$$N", with: SpeakElePublicManager.share.userInfo.userName ?? "--")
            title = title?.replacingOccurrences(of: "$$$L", with: SpeakElePublicManager.share.userInfo.nativeLanguage ?? "--")
            title = title?.whitespacesAndNew()
            titleL.text = title
            
            titleL.textAlignment = (data?.role == .speakAI ? .left : .center)
            titleL.sizeToFit()
            transLabel.text = data?.transtr
            let role = (data?.role == .speakAI ? true : false)
            contentV.snp.remakeConstraints { make in
                if role {
                    make.left.equalToSuperview().inset(marginLR)
                    make.top.equalToSuperview().inset(5)
                }else{
                    make.right.equalToSuperview().inset(marginLR)
                    make.top.equalToSuperview().inset(5)
                }
                make.width.equalTo(titleL.snp.width).offset(32)
                make.bottom.equalToSuperview().inset(16)
            }
        }
    }
    
    private func stackItem() -> [UIButton] {
        let icon = ["icon_vioce_off","icon_translate_on"]
        var i = 0
        let btns = icon.map { text in
            let btn = UIButton(type: .custom)
            btn.setBackgroundImage(UIImage(named: text), for: .normal)
            btn.tag = i
            i += 1
            btn.addTarget(self, action: #selector(transTaps(_:)), for: .touchUpInside)
            return btn
        }
        return btns
    }
    
    override func reload() {
        setNeedsLayout()
        layoutIfNeeded()
    }
    
    override func layoutSubviews() {
        super.layoutSubviews()
    }
    
    private lazy var lineV: UIView = {
        let l = UIView()
        l.backgroundColor = .init(hex: 0x000000,alpha: 0.12)
        contentV.addSubview(l)
        return l
    }()
    
    private lazy var stack: UIStackView = {
        let st = UIStackView()
        contentV.addSubview(st)
        st.spacing = 16
        st.distribution = .fill
        st.alignment = .fill
        let b = stackItem()
        b.forEach { stackBtn in
            st.addArrangedSubview(stackBtn)
            stackBtn.snp.makeConstraints { make in
                make.width.equalTo(30.adapterW())
                make.height.equalTo(stackBtn.snp.width)
            }
        }
        return st
    }()
    
    private lazy var transLabel: UILabel = {
        let l = UILabel()
        l.font = UIFont.montserrat(.regular,size: 16)
        l.textColor = .init(hex:0x000000 ,alpha: 0.9 )
        l.numberOfLines = 0
        contentV.addSubview(l)
        return l
    }()
    
    @objc private func transTaps(_ sender:UIButton) -> Void {
        if sender.tag == 0 {
            SpeakSpeechSynthesizer.share.speakText(titleL.text ?? "")
        }else{
            guard let call = callblack else { return }
            call("")
        }
    }
    
}
