//
//  SpeakEleSelectTimeViewCell.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/17.
//

import UIKit

class SpeakEleSelectTimeViewCell: SpeakEleQABaseViewCell {

    static let id = "SpeakEleQABaseViewCell"
    
    override func setup() {
        bgView.type = .speakNone
        bgView.snp.makeConstraints { make in
            make.left.right.bottom.top.equalToSuperview().inset(UIEdgeInsets(top: -10, left: -10, bottom: -10, right: -10))
        }
        contentV.snp.makeConstraints { make in
            make.right.top.bottom.equalToSuperview().inset(UIEdgeInsets(top: 2, left: 0, bottom: 16, right: (marginLR)))
            make.width.equalTo(Dev.screenW * 0.6 )
        }
        datePicker.snp.makeConstraints { make in
            make.left.right.top.bottom.equalToSuperview()
            make.height.equalTo(166)
        }
    }

    private lazy var datePicker: UIDatePicker = {
        let date = UIDatePicker()
        date.preferredDatePickerStyle = .wheels
        date.datePickerMode = .time
        date.addTarget(self, action: #selector(valueChange(_:)), for: .valueChanged)
        contentV.addSubview(date)
        return date
    }()
    
    @objc func valueChange(_ sender:UIDatePicker) -> Void {
        let tm = sender.date.toStr("hh:mm aa")
        guard let call = callblack else { return }
        call(tm)
    }
    
}
