//
//  SpeakEleQATextCell.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/15.
//

import UIKit

class SpeakEleQATextCell: SpeakEleQABaseViewCell {
    
    static let id = "SpeakEleQATextCell"
    
    override var data:SpeakEleQAModel? {
        didSet {
            bgView.type = data?.role ?? .speakAI
            
            var title = data?.speakMsg.replacingOccurrences(of: "$$$N", with: SpeakElePublicManager.share.userInfo.userName ?? "--")
            title = title?.replacingOccurrences(of: "$$$L", with: SpeakElePublicManager.share.userInfo.nativeLanguage ?? "--")
            title = title?.whitespacesAndNew()
            titleL.text = title
            
            titleL.textAlignment = (data?.role == .speakAI ? .left : .center)
            titleL.sizeToFit()
            let role = (data?.role == .speakAI ? true : false)
            contentV.snp.remakeConstraints { make in
                if role {
                    make.left.equalToSuperview().inset(marginLR)
                    make.top.equalToSuperview().inset(0)
                }else{
                    make.right.equalToSuperview().inset(marginLR)
                    make.top.equalToSuperview().inset(0)
                }
                make.width.equalTo(titleL.snp.width).offset(32)
                make.bottom.equalToSuperview().inset(16)
            }
            bgView.snp.remakeConstraints({ make in
                if role {
                    make.left.right.bottom.top.equalTo(self.titleL).inset(-16)
                }else{
                    make.left.bottom.right.top.equalTo(self.titleL).inset(UIEdgeInsets(top: -24, left: -26, bottom: -28, right: -26))
                }
            })
            
        }
    }
    
    override func reload() {
        setNeedsLayout()
        layoutIfNeeded()
    }
    
    override func layoutSubviews() {
        super.layoutSubviews()
        self.layoutIfNeeded()
        bgView.type = data?.role ?? .speakAI
    }
}
