//
//  SpeakEleQABaseViewCell.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/15.
//

import UIKit

class SpeakEleQABaseViewCell: UITableViewCell {

    var data:SpeakEleQAModel? 
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setup()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    override func awakeFromNib() {
        super.awakeFromNib()
        setup()
    }
    
    func reload() -> Void {
        
    }
    
    func setup() -> Void {
        bgView.snp.makeConstraints { make in
            make.left.right.bottom.top.equalTo(self.titleL).inset(-16)//inset(UIEdgeInsets(top: -16, left: -10, bottom: -15, right: -10))
        }
        self.titleL.snp.makeConstraints { make in
            make.left.top.bottom.right.equalToSuperview().inset(16)
            make.width.lessThanOrEqualTo(Dev.screenW * 0.7)
            make.width.greaterThanOrEqualTo(20)
            make.height.greaterThanOrEqualTo(20)
        }
    }
    
    lazy var bgView: SpeakEleImageFill = {
        let bg = SpeakEleImageFill()
        bg.setContentHuggingPriority(.defaultLow, for: .vertical)
        bg.setContentHuggingPriority(.defaultLow, for: .horizontal)
        bg.setContentCompressionResistancePriority(.defaultLow, for: .vertical)
        bg.setContentCompressionResistancePriority(.defaultLow, for: .horizontal)
        bg.contentMode = .scaleToFill
        contentV.addSubview(bg)
        return bg
    }()
    
    lazy var contentV: UIView = {
        let cv = UIView()
        contentView.addSubview(cv)
        cv.backgroundColor = .white
        return cv
    }()

    lazy var titleL: UILabel = {
        let title = UILabel()
        title.font = UIFont.montserrat(.regular,size: 16)
        title.textColor = .init(hex:0x000000 ,alpha: 0.9 )
        title.numberOfLines = 0
        contentV.addSubview(title)
        return title
    }()
}
