//
//  SpeakEleSelectBoxViewCell.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/15.
//

import UIKit

class SpeakEleMutabSelectBoxViewCell: SpeakEleQABaseViewCell {

    
    static let id = "SpeakEleMutabSelectBoxViewCell"
    var type:SpeakMessageType = .language
    
    private var items:[UIButton] = []
    
    var selectSets = NSMutableSet()
    
    var change = false
    var max = 7
    var isMore = true
    
    var datastr:[String] = [] {
        didSet {
            bgView.type = .speakNone
            let len = min(datastr.count, max)
            var btns:[String] = datastr[0..<len].map({String($0)})
            if !isMore {
                btns = datastr
            }
            self.layoutIfNeeded()
            if items.count != btns.count  || change {
                change = false
                contentV.subviews.forEach { view in
                    if view is SpeakEleImageFill {
                    }else{
                        view.removeFromSuperview()
                    }
                }
                items.removeAll()
                let height:CGFloat = 30
                let content = UIEdgeInsets(top: 16, left: 16, bottom: 16, right: 16)
                var offsetX:CGFloat = content.left
                var offsetY:CGFloat = content.top
                let spaing:CGFloat = 10;
                
                for (i,str) in btns.enumerated() {
                    let btn = UIButton(type: .custom)
                    btn.setTitle(str, for: .normal)
                    btn.titleLabel?.font = UIFont.montserrat(.regular,size: 16)
                    btn.setTitleColor(.black, for: .normal)
                    btn.corners = 8
                    btn.borderWidth = 1
                    btn.borderColor = .init(hex: 0x6B71E3)
                    btn.contentEdgeInsets = UIEdgeInsets(top: 8, left: 8, bottom: 8, right: 8)
                    btn.addTarget(self, action: #selector(btnTaps(_:)), for: .touchUpInside)
                    contentV.addSubview(btn)
                    items.append(btn)
                    
                    btn.tag = i
                    let size = str.size(withFont: UIFont.montserrat(.regular,size: 16))
                    let width = size.width + 4 + 16
                    
                    if ((offsetX + width + content.right) > Dev.screenW - 40 - marginLR) {
                        offsetX = content.left
                        offsetY += (height+spaing)
                    }
                    btn.snp.makeConstraints { make in
                        make.left.equalToSuperview().inset(offsetX)
                        make.top.equalToSuperview().inset(offsetY)
                        make.size.equalTo(CGSize(width: width, height: height))
                        if !isMore && i == (btns.count-1) {
                            make.bottom.equalToSuperview().inset(16)
                        }
                    }
                    offsetX += (width + spaing)
                }
                if isMore {
                    let more = UIButton(type: .custom)
                    more.setTitle("More", for: .normal)
                    more.titleLabel?.font = UIFont.montserrat(.regular,size: 16)
                    more.setTitleColor(.init(hex: 0x3980F6), for: .normal)
                    more.backgroundColor = .init(hex: 0x3980F6,alpha: 0.2)
                    more.corners = 8
                    more.addTarget(self, action: #selector(moreTaps), for: .touchUpInside)
                    contentV.addSubview(more)
                    let size = "More".size(withFont: UIFont.montserrat(.regular,size: 16))
                    let width = size.width + 10.0
                    if ((offsetX + width + content.right) > contentV.width) {
                        offsetX = content.left
                        offsetY += (height+spaing)
                    }
                    more.snp.makeConstraints { make in
                        make.left.equalToSuperview().inset(offsetX)
                        make.top.equalToSuperview().inset(offsetY)
                        make.size.equalTo(CGSize(width: width, height: height))
                        make.bottom.equalToSuperview().inset(16)
                    }
                }
            }
            
        }
    }
    
    override func setup() -> Void {
        bgView.snp.makeConstraints { make in
            make.left.right.bottom.top.equalToSuperview().inset(UIEdgeInsets(top: -8, left: -8, bottom: -8, right: -8))
        }
        contentV.snp.makeConstraints { make in
            make.right.top.left.bottom.equalToSuperview().inset(UIEdgeInsets(top: 2, left: 40, bottom: 16, right: (marginLR)))
        }
    }
    
    override func reload() {
        self.setNeedsLayout()
        self.layoutIfNeeded()
        items.forEach { btn in
            if self.selectSets.contains(btn.tag) {
                btn.backgroundColor = .init(hex: 0x3980F6)
                btn.setTitleColor(.white, for: .normal)
                btn.borderColor = .clear
            }else{
                btn.backgroundColor = .white
                btn.setTitleColor(.black, for: .normal)
                btn.borderColor = .init(hex: 0x3980F6)
            }
        }
    }
    
    override func layoutSubviews() {
        super.layoutSubviews()
        self.layoutIfNeeded()
    }
    
    @objc private func moreTaps(){
        let moreView = SpeakEleQAMoreViewCtr(items: datastr, state: self.type)
        moreView.show { [weak self] ts in
            let it = self?.items.map({$0.titleLabel?.text ?? ""}) ?? []
            if it.contains(ts) {
                for (i,v) in it.enumerated() {
                    if v == ts {
                        guard let call = self?.callblack else { return }
                        call(i)
                        break
                    }
                }
            }else{
                self?.change = true
                guard let call = self?.callblack else { return }
                call(ts)
            }
        }
    }
    
    @objc private func btnTaps(_ sender:UIButton) -> Void {
        guard let call = callblack else { return }
        call(sender.tag)
    }
    
}
