//
//  SpeakEleGuideViewCtr.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/11.
//

import UIKit

class SpeakEleGuideViewCtr: SpeakEleBaseViewCtr ,UIScrollViewDelegate {

    // MARK: - ib
    @IBOutlet weak var SpeakScroll: UIScrollView!
    
    
    @IBOutlet var SpeakTrustIcons: [UIImageView]!
    @IBOutlet var SpeakTrustNames: [UILabel]!
    @IBOutlet var SpeakTrustNatrls: [UILabel]!
    @IBOutlet var SpeakTrustDescptionL: [UILabel]!
    
    @IBOutlet var SpeakTrustContentVs: [UIView]!
    
    private var selectIdx:Double = 0 {
        didSet {
            UIView.animate(withDuration: 0.35) {
                self.SpeakScroll.contentOffset = CGPointMake(self.selectIdx * self.SpeakScroll.width, 0)
            }
        }
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        SpeakScroll.delegate = self
        selectIdx = 0
        
        let data = SpeakReviewViewModel.GuideReview
        for (i,value) in data.enumerated() {
            SpeakTrustIcons[safe:i]?.image = UIImage(named: value.image)
            SpeakTrustNames[safe:i]?.text = value.name
            SpeakTrustNatrls[safe:i]?.text = value.country
            SpeakTrustDescptionL[safe:i]?.text = value.descption
        }
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        titleView.isHidden = true
        self.navigationController?.interactivePopGestureRecognizer?.isEnabled = false
    }

    override func viewDidLayoutSubviews() {
        super.viewDidLayoutSubviews()
        self.view.layoutIfNeeded()
        SpeakTrustContentVs.forEach { trust in
            trust.shadow(cornerRadius: 12, shadowColor: .init(hex: 0x49D9F9,alpha: 0.1), offset: CGSizeMake(0, 0), opacity: 1, radius: 3)
        }
    }
    
    @IBAction func SpeakNextTaps(_ sender: Any) {
        if selectIdx >= 2 {
            if let isThree = UserDefaults.standard.object(forKey: UnsafeRawUserDefaultsKey.UnsafeThreeDayGuide.rawValue) as? Bool {
                if isThree {
                    if IAPViewModel.share.isSubscribed {
                        let QAndA = SpeakEleQAViewCtr()
                        self.navigationController?.pushViewController(QAndA, animated: true)
                    }else{
                        SpeakElePublicManager.share.PublicData.state = .subscribe
                        let iap = SpeakEleIAPViewCtr()
                        iap.state = .guide
                        self.navigationController?.AnimationState = .present
                        self.navigationController?.pushViewController(iap, animated: true)
                    }
                }
            }else {
                UserDefaults.standard.set(true, forKey: UnsafeRawUserDefaultsKey.UnsafeThreeDayGuide.rawValue)
                toIAP(self)
            }
        }else{
            selectIdx += 1
        }
    }
    
    func scrollViewDidEndDecelerating(_ scrollView: UIScrollView) {
        selectIdx = scrollView.contentOffset.x / scrollView.width
    }
}
