//
//  SpeakEleGeneratePlanView.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/17.
//

import UIKit

class SpeakEleGeneratePlanView: UIView {

    enum generatePlanState {
    case none
    case start
    case finish
    }
    
    private var Plan:String = ""
    var state:generatePlanState = .none
    
    var offset:Int = 0 {
        didSet{
            DispatchQueue.main.async {
                if self.state == .none {
                    
                }else if self.state == .start {
                    self.info.isHidden = false
                    self.SpeakOffsetL.text = "\(self.offset)%"
                    self.SpeakL.textColor = .init(hex: 0x000000,alpha: 0.54)
                    self.animationLayer.frame = CGRectMake(0, 0, self.ProgressV.width * (CGFloat(self.offset) / 100.0), 60)
                    self.layoutIfNeeded()
                }else{
                    self.SpeakL.textColor = .init(hex: 0x000000,alpha: 0.9)
                    self.SpeakOffsetL.isHidden = true
                    self.layoutIfNeeded()
                    DispatchQueue.main.asyncAfter(deadline: .now() + 0.01, execute: {
                        self.setNeedsDisplay()
                        UIView.animate(withDuration: 0.4) {
                            self.animationLayer.frame = CGRectMake(0, 0, self.ProgressV.width, 12)
                            self.ProgressV.snp.updateConstraints({ make in
                                make.height.equalTo(12)
                                self.layoutIfNeeded()
                            })
                        }
                    })
                    self.stop()
                }
                
            }
        }
    }
    
    init(string:String) {
        self.Plan = string
        super.init(frame: CGRect())
        self.setup()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private func setup() -> Void {
        SpeakL.snp.makeConstraints { make in
            make.left.top.equalToSuperview()
            make.height.greaterThanOrEqualTo(20)
            make.right.equalTo(info.snp.left).inset(10)
        }
        info.snp.makeConstraints { make in
            make.right.equalToSuperview()
            make.size.equalTo(CGSizeMake(20, 20))
        }
        ProgressV.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.top.equalTo(SpeakL.snp.bottom).offset(10)
            make.height.equalTo(60)
        }
        SpeakOffsetL.snp.makeConstraints { make in
            make.left.equalTo(ProgressV.snp.left).offset(20)
            make.centerY.equalTo(ProgressV.snp.centerY)
        }
        self.layoutIfNeeded()
    }
    
    private lazy var SpeakL: UILabel = {
        let l = UILabel()
        l.font = UIFont.montserrat(.semiBold,size: 18)
        l.textColor = .init(hex: 0x000000 ,alpha: 0.54)
        l.text = Plan
        l.numberOfLines = 0
        addSubview(l)
        return l
    }()
    
    private lazy var info: UIImageView = {
        let info = UIImageView(image: UIImage(named: "icon_Plan_Loading"))
        info.contentMode = .scaleAspectFill
        info.isHidden = true
        addSubview(info)
        return info
    }()
    
    private lazy var ProgressV: UIView = {
        let v = UIView()
        v.corners = 6
        v.backgroundColor = .init(hex: 0x6B99E3,alpha: 0.1)
        addSubview(v)
        v.clipsToBounds = true
        return v
    }()
    
    private lazy var SpeakOffsetL: UILabel = {
        let l = UILabel()
        l.font = UIFont.montserrat(.semiBold,size: 28)
        l.textColor = .white
        l.numberOfLines = 0
        addSubview(l)
        return l
    }()
    
    func startRotation() -> Void {
        if info.layer.animationKeys()?.count ?? 0 <= 0{
            let rotation = CABasicAnimation(keyPath: "transform.rotation.z")
            rotation.toValue = NSNumber(value: .pi * 2.0) // 旋转 360 度
            rotation.duration = 1
            rotation.repeatCount = .infinity // 无限旋转
            rotation.isRemovedOnCompletion = false
            rotation.fillMode = .forwards
            info.layer.add(rotation, forKey: "rotationAnimation")
        }
    }
    
    func stop() -> Void {
        info.layer.removeAllAnimations()
        info.image = UIImage(named: "icon_Plan_Finish")
    }
    
    private lazy var animationLayer: CALayer = {
        let l = CALayer()
        l.backgroundColor = UIColor.init(hex: 0x3980F6).cgColor
        ProgressV.layer.insertSublayer(l, at: 1)
        return l
    }()
    
//    override func layoutSubviews() {
//        super.layoutSubviews()
//        self.layoutIfNeeded()
//    }
}
