//
//  SpeakFreeTalkSendToCell.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/9/8.
//

import UIKit

class SpeakFreeTalkSendToCell: UITableViewCell {

    static let id = "SpeakFreeTalkSendToCell"
        
    @IBOutlet weak var SpeakFreeTalkIcon: UIImageView!
    @IBOutlet weak var SpeakFreeTalkDescp: UILabel!
    
    var data:SpeakFreeTalkModel? {
        didSet {
            SpeakFreeTalkDescp.text = data?.content
            SpeakFreeTalkDescp.sizeToFit()
        }
    }
    
    override func awakeFromNib() {
        super.awakeFromNib()
        self.selectionStyle = .none
    }
    
    override func layoutSubviews() {
        super.layoutSubviews()
        if let image = UIImage(named: "sp-guideQA-An") {
            let center = CGPoint(x: image.size.width / 2, y: image.size.height / 2)
            let insets = UIEdgeInsets(
                top: center.y,
                left: center.x,
                bottom: center.y,
                right: center.x
            )
            SpeakFreeTalkIcon.contentMode = .scaleToFill
            SpeakFreeTalkIcon.image = image.resizableImage(withCapInsets: insets, resizingMode: .stretch)
        }
    }

}
