//
//  SpeakFreeTalkAIReceveCell.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/9/8.
//

import UIKit

class SpeakFreeTalkAIReceveCell: UITableViewCell {
    
    static let id = "SpeakFreeTalkAIReceveCell"

    @IBOutlet weak var speakBg: UIImageView!
    @IBOutlet weak var SpeakContent: UILabel!
    @IBOutlet weak var SpeakNavtiveL: UILabel!
    
    var isTranslate = false
    
    @IBOutlet weak var SpeakTranslate: UIButton!
    
    var isMute = false
    
    override func awakeFromNib() {
        super.awakeFromNib()
        self.selectionStyle = .none
    }
    
    var data:SpeakFreeTalkModel? {
        didSet {
            SpeakContent.text = data?.content
            SpeakTranslate.isSelected = isTranslate
            if isTranslate {
                SpeakNavtiveL.text = data?.translate
            }else{
                SpeakNavtiveL.text = ""
            }
            SpeakNavtiveL.isHidden = !(SpeakNavtiveL.text?.count ?? 0 > 0)
            SpeakContent.sizeToFit()
            SpeakNavtiveL.sizeToFit()
        }
    }
    
    override func layoutSubviews() {
        super.layoutSubviews()
        if let image = UIImage(named: "sp-guideQA-Qu") {
            let center = CGPoint(x: image.size.width / 2, y: image.size.height / 2)
            let insets = UIEdgeInsets(
                top: center.y,
                left: center.x,
                bottom: center.y,
                right: center.x
            )
            speakBg.contentMode = .scaleToFill
            speakBg.image = image.resizableImage(withCapInsets: insets, resizingMode: .stretch)
        }
    }
    
    /// 播放音频
    @IBAction func SpeakAudioTaps(_ sender: Any) {
        AudioPlayerManager.shared.task = []
        let speed = SpeakElePublicManager.share.PublicData.speed
        if let audio = data?.video {
            let d = AudioPlayerManager.shared.setupAudioPlayer(with: audio ,isMuted: isMute)
            SpeakAIVideoPlayManager.share.PlaySpeak(d/speed)
        }else if let audio = SpeakCache.cache.loadData(fileName: "\(data?.recordId ?? 0)") {
            let d = AudioPlayerManager.shared.setupAudioPlayer(with: audio ,isMuted:  isMute)
            SpeakAIVideoPlayManager.share.PlaySpeak(d/speed)
        }
    }
    
    /// 翻译
    @IBAction func SpeakTranslateTaps(_ sender: Any) {
        AudioPlayerManager.shared.stop()
        SpeakAIVideoPlayManager.share.PlayBg()
        AudioPlayerManager.shared.task = []
        guard let callblack = callblack else { return }
        callblack(data?.content)
    }
    
    /// 倍速
    @IBAction func SpeakSpeedTaps(_ sender: Any) {
        AudioPlayerManager.shared.task = []
        if let audio = data?.video {
            let d = AudioPlayerManager.shared.setupAudioPlayer(with: audio)
            AudioPlayerManager.shared.setupAudioPlayer(with: audio ,isMuted: isMute, rate: 0.5)
            SpeakAIVideoPlayManager.share.PlaySpeak(d/0.5)
        }else if let audio = SpeakCache.cache.loadData(fileName: "\(data?.recordId ?? 0)") {
            let d = AudioPlayerManager.shared.setupAudioPlayer(with: audio)
            AudioPlayerManager.shared.setupAudioPlayer(with: audio ,isMuted: isMute, rate: 0.5)
            SpeakAIVideoPlayManager.share.PlaySpeak(d/0.5)
        }
    }
    
    deinit {
        callblack = nil
    }
    
}
