//
//  SpeakProgressViewModel.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/22.
//

import UIKit

class SpeakProgressViewModel: NSObject {

    func currentWeek() -> [Date] {
        let calendar = Calendar.current
        let today = Date()
        let weekday = calendar.component(.weekday, from: today)
        let monday = calendar.date(byAdding: .day, value: 2 - weekday, to: today)!
        let dateFormatter = DateFormatter()
        dateFormatter.dateFormat = "yyyyMMdd"
        return (0..<7).compactMap { dayOffset in
            let date = calendar.date(byAdding: .day, value: dayOffset, to: monday)
            return date
        }
    }
    
    func lastCurrentWeek() -> [Date] {
        let calendar = Calendar.current
        let today = Date()
        let weekday = calendar.component(.weekday, from: today)
        let monday = calendar.date(byAdding: .day, value: 2 - weekday - 7, to: today)!
        let dateFormatter = DateFormatter()
        dateFormatter.dateFormat = "yyyyMMdd"
        return (0..<7).compactMap { dayOffset in
            let date = calendar.date(byAdding: .day, value: dayOffset, to: monday)
            return date
        }
    }
}
