//
//  SpeakProgressStudySecCell.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/22.
//

import UIKit

class SpeakProgressStudySecCell: UICollectionViewCell {

    static let id = "SpeakProgressStudySecCell"
    
    var data:SpeakDayModel? {
        didSet {
            if ((self.data?.studytime ?? 0) / 60) > 0{
                self.SpeakMaxLabel.text = "\((self.data?.studytime ?? 0) / 60)min"
            }else{
                self.SpeakMaxLabel.text = ""
            }
            let date = self.data?.date
            let min = date?.date()?.toStr("MM/dd")
            self.SpeakStudyTm.text = min
        }
    }

    
    @BoundedDoubleNumber var progress:Double = 0 {
        didSet {
            DispatchQueue.main.asyncAfter(deadline: .now() + 0.01) {
                self.setProgress()
            }
        }
    }
    
    // MARK: - ib
    @IBOutlet weak var SpeakMaxLabel: UILabel!
    @IBOutlet weak var SpeakProgressView: UIView!
    @IBOutlet weak var SpeakStudyTm: UILabel!
    
    var color:UIColor = .clear {
        didSet {
            SpeakMaxLabel.textColor = color
            ProgressLayer.backgroundColor = color
        }
    }
    
    override func awakeFromNib() {
        super.awakeFromNib()
        ProgressLayer.frame = CGRect()
    }

    func setProgress() -> Void {
        self.layoutIfNeeded()
        let height = self.SpeakProgressView.height
        let frame = CGRect(x: 0, y: height * (1.0-progress) , width: self.SpeakProgressView.width, height: height * progress)
        self.ProgressLayer.frame = frame
        self.ProgressLayer.corners = self.SpeakProgressView.width / 2.0
    }
    
    private lazy var ProgressLayer: UIView = {
        let l = UIView()
        SpeakProgressView.addSubview(l)
        return l
    }()
}
