//
//  SpeakProgressReviewCell.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/22.
//

import UIKit

class SpeakProgressReviewCell: UITableViewCell {

    static let id = "SpeakProgressReviewCell"
    // MARK: - ib
    
    @IBOutlet weak var SpeakReviewNewL: UILabel!
    @IBOutlet weak var SpeakReviewFamiliar: UILabel!
    @IBOutlet weak var SpeakReviewStrangeL: UILabel!
    
    
    override func awakeFromNib() {
        super.awakeFromNib()
    }
    
    @IBAction func SpeakReviewNowTaps(_ sender: Any) {
        guard let tabbar:SpeakEleTabbarViewCtr = self.responderCtr()?.parent as? SpeakEleTabbarViewCtr else { return }
        tabbar.selectIndex = 1
    }
    
    @IBAction func SpeakReviewInfoTaps(_ sender: Any) {
        let review = SpeakEleReviewWordViewCtr()
        review.data = self.data
        self.responderCtr()?.parent?.navigationController?.pushViewController(review, animated: true)
    }
    
    var data:SpeakProgressWordCountModel? {
        didSet {
            SpeakReviewNewL.text = "\(data?.newWordCount ?? 0)"
            SpeakReviewFamiliar.text = "\(data?.familiarCount ?? 0)"
            SpeakReviewStrangeL.text = "\(data?.unfamiliarCount ?? 0)"
        }
    }
}
