//
//  SpeakProHistoryCell.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/23.
//

import UIKit

class SpeakProHistoryCell: UITableViewCell {

    static let id = "SpeakProHistoryCell"
    
    @IBOutlet weak var SpeakProHistoryIcon: UIImageView!
    @IBOutlet weak var SpeakProHistoryLessName: UILabel!
    @IBOutlet weak var SpeakProHistoryTm: UILabel!
    @IBOutlet weak var SpeakProHistoryProg: UILabel!
    
    @IBOutlet weak var SpeakProHistoryResult: UIImageView!
    
    var data:SpeakProgressHisLessasMode?{
        didSet{
            let imgs = (lessonImage[safe: (Int(data?.lessonId ?? "") ?? 0) % 5] ?? .gray).rawValue
            SpeakProHistoryIcon.image = UIImage(named: imgs)
            SpeakProHistoryLessName.text = data?.lessonName
            SpeakProHistoryProg.text = "Reviewed \(data?.learnedVocabularyCount ?? 0)/\(data?.wordCount ?? 0)"
            let tm = Date(timeIntervalSince1970: data?.updateTime?.convertToTimestamp() ?? 0).toStr("MMM dd yyyy、hh:mm aaa")
            SpeakProHistoryTm.text = tm
            let su = (data?.learnedVocabularyCount ?? 0 >= data?.wordCount ?? 0)
            SpeakProHistoryResult.contentMode = .scaleToFill
            SpeakProHistoryResult.image = UIImage(named: su ? "icon_huizhang" : "icon_jinduquan")
        }
    }
    
    override func awakeFromNib() {
        super.awakeFromNib()
    }

    override func layoutSubviews() {
        super.layoutSubviews()
        self.layoutIfNeeded()
        let su = (data?.learnedVocabularyCount ?? 0 >= data?.wordCount ?? 0)
        if su == false {
            shape.frame = self.SpeakProHistoryResult.bounds
            let width = self.SpeakProHistoryResult.width
            let arc = CGFloat(data?.learnedVocabularyCount ?? 0)/CGFloat(data?.wordCount ?? 1) * (Double.pi * 2.0)
            let path = UIBezierPath(arcCenter: CGPoint(x: width/2.0, y: width/2.0), radius: width/2.0-2, startAngle: -Double.pi/2.0, endAngle: -Double.pi/2.0 + arc, clockwise: true)
            shape.path = path.cgPath
            shape.lineWidth = 3
            shape.lineCap = .round
            shape.setNeedsLayout()
        }
    }
    
    private lazy var shape: CAShapeLayer = {
        let s = CAShapeLayer()
        SpeakProHistoryResult.layer.addSublayer(s)
        s.backgroundColor = UIColor.clear.cgColor
        s.fillColor = UIColor.clear.cgColor
        s.strokeColor = UIColor.init(hex: 0xFFB200).cgColor
        return s
    }()
}
