//
//  SpeakEleDebriefViewCell.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/8/4.
//

import UIKit

class SpeakEleDebriefViewCell: UITableViewCell {

    static let id = "SpeakEleDebriefViewCell"
    
    @IBOutlet weak var Sentence: UILabel!
    
    @IBOutlet weak var WordT: UILabel!
    @IBOutlet weak var WordInfo: UIButton!
    @IBOutlet weak var WordDescpT: UILabel!
    
    @IBOutlet weak var SpeakContentV: UIView!
    @IBOutlet weak var SpeakReViewNowBtn: UIButton!
    @IBOutlet weak var SpeakLineV: UIView!
    
    override func awakeFromNib() {
        super.awakeFromNib()
        self.clipsToBounds = true
        self.selectionStyle = .none
        isOpen = false
    }
    
    var isOpen:Bool  = false {
        didSet {
            WordInfo.isSelected = isOpen
            self.WordDescpT.isHidden = !isOpen
        }
    }
    
    var data:SpeakProgressCorrect? {
        didSet {
            WordDescpT.text = data?.error
            WordT.text = data?.correct
            let att = NSAttributedString(string: data?.origin ?? "", attributes: [NSAttributedString.Key.strikethroughStyle : NSUnderlineStyle.single.rawValue,.strikethroughColor:UIColor.black])
            Sentence.attributedText = att
        }
    }
    
    @IBAction func ReViewNowTouch(_ sender: Any) {
        guard let call = callblack else { return }
        call("")
    }
    
    deinit {
        callblack = nil
    }
}
