//
//  SpeakProgressWeekCell.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/22.
//

import UIKit

class SpeakProgressWeekCell: UICollectionViewCell {

    static let id = "SpeakProgressWeekCell"
    
    // MARK: - ib

    @IBOutlet weak var SpeakProgressInfo: UIImageView!
    @IBOutlet weak var SpeakWeedLabel: UILabel!
    @IBOutlet weak var SpeakContentV: UIView!
    
    var isLast = false {
        didSet {
            lineV.isHidden = isLast
        }
    }
    
    override func awakeFromNib() {
        super.awakeFromNib()
        self.SpeakContentV.corners = 8
        lineV.snp.makeConstraints { make in
            make.left.equalTo(self.snp.right)
            make.centerY.equalToSuperview()
            make.width.equalTo(16)
            make.height.equalTo(1)
        }
    }
    
    override func layoutSubviews() {
        super.layoutSubviews()
        self.layoutIfNeeded()
        lineV.dashPattern(dashColor: .init(hex: 0x000000,alpha: 0.26))
    }
    
    private lazy var lineV: UIView = {
        let v = UIView()
        self.addSubview(v)
        return v
    }()

}
