//
//  SpeakProgressSignCell.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/21.
//

import UIKit

class SpeakProgressSignCell: UITableViewCell {

    static let id = "SpeakProgressSignCell"
    
    // MARK: - ib
    @IBOutlet weak var SpeakContentV: UIView!
    @IBOutlet weak var SpeakSignNumL: UILabel!
    @IBOutlet weak var SpeakCollectionView: UICollectionView!
    private let viewModel = SpeakProgressViewModel()
    
    override func awakeFromNib() {
        super.awakeFromNib()
        self.backgroundColor = .clear
        setup()
        dataSource = self.viewModel.currentWeek()
    }
    
    private func setup() -> Void {
        self.SpeakCollectionView.delegate = self
        self.SpeakCollectionView.dataSource = self
        self.SpeakCollectionView.register(UINib(nibName: SpeakProgressWeekCell.id, bundle: nil), forCellWithReuseIdentifier: SpeakProgressWeekCell.id)
        
    }
    
    override func layoutSubviews() {
        super.layoutSubviews()
        self.layoutIfNeeded()
        SpeakContentV.corners = 16
    }
    
    private var dataSource:[Date]?
    
    var signList:[String:[SignListModel]]? {
        didSet{
            var num = 0
            if let values = signList?.values {
                for (v) in values {
                    num += v.count
                }
            }
            SpeakSignNumL.text = "\(num)"
            self.SpeakCollectionView.reloadData()
        }
    }
}

extension SpeakProgressSignCell :UICollectionViewDataSource,UICollectionViewDelegate,UICollectionViewDelegateFlowLayout {
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        return dataSource?.count ?? 0
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: SpeakProgressWeekCell.id, for: indexPath) as! SpeakProgressWeekCell
        cell.SpeakContentV.alpha = 1
        let date = dataSource?[indexPath.row]
        cell.SpeakWeedLabel.text = date?.toWeek()
        cell.isLast = indexPath.row == (dataSource?.count ?? 0)-1
        let dateKey = date?.toStr("yyyy-MM") ?? ""
        cell.alpha = 1
        if let s = signList?[dateKey] as? [SignListModel] {
            let dk = date?.toStr("yyyy-MM-dd") ?? ""
            let arr = s.filter({$0.signDate == dk})
            if dk == Date().toStr("yyyy-MM-dd") {
                cell.SpeakContentV.backgroundColor = .init(hex: 0x3980F6,alpha: 0.2)
                cell.SpeakWeedLabel.textColor = .init(hex: 0x3980F6)
                cell.SpeakProgressInfo.image = UIImage(named: "sp-progress-Check")
            }else if arr.count > 0 {
                cell.SpeakContentV.backgroundColor = .init(hex: 0x3980F6,alpha: 0.2)
                cell.SpeakWeedLabel.textColor = .init(hex: 0x3980F6)
                cell.SpeakProgressInfo.image = UIImage(named: "sp-progress-Check")
                cell.SpeakWeedLabel.alpha = 0.2
                cell.SpeakProgressInfo.alpha = 0.2
            }else{
                cell.SpeakProgressInfo.image = UIImage(named: "icon_check_off")
                cell.SpeakContentV.backgroundColor = .init(hex: 0x000000,alpha: 0.08)
                cell.SpeakWeedLabel.textColor = .init(hex: 0x000000,alpha: 0.4)
            }
        }else{
            cell.SpeakProgressInfo.image = UIImage(named: "icon_check_off")
            cell.SpeakContentV.backgroundColor = .init(hex: 0x000000,alpha: 0.08)
            cell.SpeakWeedLabel.textColor = .init(hex: 0x000000,alpha: 0.4)
        }
        return cell
    }
 
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, minimumLineSpacingForSectionAt section: Int) -> CGFloat {
        return 16
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, minimumInteritemSpacingForSectionAt section: Int) -> CGFloat {
        return 0
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, insetForSectionAt section: Int) -> UIEdgeInsets {
        return UIEdgeInsets()
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        let height = collectionView.height
        let width = collectionView.height * (60/80.0)
        return CGSizeMake(width, height)
    }
    
}
