//
//  SpeakProgressHistoryViewCtr.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/23.
//

import UIKit

class SpeakProgressHistoryViewCtr: SpeakEleBaseViewCtr {

    
    @IBOutlet weak var SpeakHistoryTableView: UITableView!
    
    private let viewModel = SpeakProgressNetViewModel()
    
    @IBOutlet weak var noDataView: UILabel!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        self.title = "History class records"
        self.view.backgroundColor = .init(hex: 0xF6F7F9)
        self.noDataView.isHidden = true
        viewModel.historyRecord { [weak self] (su, data:[SpeakProgressHisLessasMode]?) in
            if su {
                self?.datasource = data ?? []
            }
            self?.noDataView.isHidden = (self?.datasource.count ?? 0 > 0)
        }
    }

    override func setup() {
        SpeakHistoryTableView.delegate = self
        SpeakHistoryTableView.dataSource = self
        SpeakHistoryTableView.separatorStyle = .none
        SpeakHistoryTableView.showsVerticalScrollIndicator = false
        SpeakHistoryTableView.showsHorizontalScrollIndicator = false
        SpeakHistoryTableView.register(UINib(nibName: SpeakProHistoryCell.id, bundle: nil), forCellReuseIdentifier: SpeakProHistoryCell.id)
    }
    
    private var datasource:[SpeakProgressHisLessasMode] = [] {
        didSet{
            self.SpeakHistoryTableView.reloadData()
        }
    }
    
}

extension SpeakProgressHistoryViewCtr : UITableViewDelegate,UITableViewDataSource {
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return datasource.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: SpeakProHistoryCell.id, for: indexPath) as! SpeakProHistoryCell
        cell.data = self.datasource[safe: indexPath.row]
        cell.selectionStyle = .none
        return cell
    }
    
}
