//
//  SpeakEleProgressViewCtr.swift
//  SpeakEasyLearnEnglish
//
//  Created by mac on 2025/7/15.
//

import UIKit

class SpeakEleProgressViewCtr: SpeakEleBaseViewCtr {

    enum ProgressData:Int {
        case headerSign // 签到
        case studyTm    // 时长
        case review     // 数据
        case list       // 按钮列表
    }
    
    private var dataSource:[ProgressData] = [.headerSign ,.studyTm ,.review ,.list]
    private var reviewData:SpeakProgressWordCountModel?
    @IBOutlet weak var SpeakTableView: UITableView!
    private let netViewmodel = SpeakProgressNetViewModel()
    
    var dayStudy:[SpeakDayModel] = []
    
    private var selectIdx = 0
    
    override func viewDidLoad() {
        super.viewDidLoad()
        self.view.backgroundColor = UIColor.init(with: "#F6F7F9")
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        titleView.isHidden = true
        loadData()
        speakSignListViewModel.share.fetchSign { [weak self] in
            self?.loadDataBT()
            if let cell = self?.SpeakTableView.cellForRow(at: IndexPath(row: 1, section: 0)) as? SpeakProgressStudyCell {
                cell.data = self?.dayStudy ?? []
            }
            if let cell = self?.SpeakTableView.cellForRow(at: IndexPath(row: 0, section: 0)) as? SpeakProgressSignCell {
                cell.signList = speakSignListViewModel.share.signList
            }
        }
    }
    
    func loadDataBT() -> Void {
        var ddd:[String] = []
        if self.selectIdx == 0 {
            for i in 0..<3 {
                guard let db = Date().operation(day: -i).toStr() else { return }
                ddd.append(db)
            }
            ddd = ddd.reversed()
        }else if selectIdx == 1 {
            ddd = SpeakProgressViewModel().currentWeek().map({$0.toStr() ?? ""})
        }else {
            ddd = SpeakProgressViewModel().lastCurrentWeek().map({$0.toStr() ?? ""})
        }
        let dateas = SpeakDayEveryManager.manager.fetchStudyTime(date: ddd, complate: nil)
        self.dayStudy = []
        for da in ddd {
            var d = SpeakDayModel(date: da)
            let v = dateas.filter({$0.date == da})
            d.studytime = v.first?.studytime ?? 0
            self.dayStudy.append(d)
        }
    }
    
    override func setup() {
        self.SpeakTableView.delegate = self
        self.SpeakTableView.dataSource = self
        self.SpeakTableView.backgroundColor = .clear
        self.SpeakTableView.sectionHeaderTopPadding = 0
        self.SpeakTableView.sectionHeaderHeight = 0.01
        self.SpeakTableView.sectionFooterHeight = 0.01
        self.SpeakTableView.register(UINib(nibName: SpeakProgressSignCell.id, bundle: nil), forCellReuseIdentifier: SpeakProgressSignCell.id)
        self.SpeakTableView.register(UINib(nibName: SpeakProgressStudyCell.id, bundle: nil), forCellReuseIdentifier: SpeakProgressStudyCell.id)
        self.SpeakTableView.register(UINib(nibName: SpeakProgressReviewCell.id, bundle: nil), forCellReuseIdentifier: SpeakProgressReviewCell.id)
        self.SpeakTableView.register(UINib(nibName: SpeakEleProgressListCell.id, bundle: nil), forCellReuseIdentifier: SpeakEleProgressListCell.id)
        self.SpeakTableView.showsVerticalScrollIndicator = false
        self.SpeakTableView.showsHorizontalScrollIndicator = false
        
    }
    
    override func loadData() -> Void {
        netViewmodel.leassionWord {[weak self] (su, data:SpeakProgressWordCountModel?) in
            if su {
                self?.reviewData = data
                self?.SpeakTableView.reloadRows(at: [IndexPath(row: 2, section: 0)], with: .none)
            }
        }
    }
}

extension SpeakEleProgressViewCtr: UITableViewDelegate,UITableViewDataSource {
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return dataSource.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let state = dataSource[indexPath.row]
        if state == .headerSign {
            let cell = tableView.dequeueReusableCell(withIdentifier: SpeakProgressSignCell.id, for: indexPath) as! SpeakProgressSignCell
            cell.selectionStyle = .none
            cell.signList = speakSignListViewModel.share.signList
            return cell
        }else if state == .studyTm {
            let cell = tableView.dequeueReusableCell(withIdentifier: SpeakProgressStudyCell.id, for: indexPath) as! SpeakProgressStudyCell
            cell.data = self.dayStudy
            cell.selectIdx = self.selectIdx
            cell.callblack = {[weak self] tag in
                if let g = tag as? Int{
                    self?.selectIdx = g
                    self?.loadDataBT()
                    self?.view.layoutIfNeeded()
                    cell.selectIdx = g
                    cell.data = self?.dayStudy ?? []
                    self?.view.layoutIfNeeded()
//                    tableView.reloadData()
                }
            }
            cell.selectionStyle = .none
            return cell
        }else if state == .review{
            let cell = tableView.dequeueReusableCell(withIdentifier: SpeakProgressReviewCell.id, for: indexPath) as! SpeakProgressReviewCell
            cell.data = self.reviewData
            cell.selectionStyle = .none
            return cell
        }else{
            let cell = tableView.dequeueReusableCell(withIdentifier: SpeakEleProgressListCell.id, for: indexPath) as! SpeakEleProgressListCell
            cell.selectionStyle = .none
            cell.callblack = { [weak self] idx in
                if let i = idx as? Int {
                    if i == 2 {
                        let history = SpeakProgressHistoryViewCtr()
                        self?.parent?.navigationController?.pushViewController(history, animated: true)
                    }else if i == 1 {
                        let debrief = SpeakEleDebriefViewCtr(state: .debrie)
                        self?.parent?.navigationController?.pushViewController(debrief, animated: true)
                    }else{
                        let debrief = SpeakEleDebriefViewCtr(state: .correct)
                        self?.parent?.navigationController?.pushViewController(debrief, animated: true)
                    }
                }
            }
            return cell
        }
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        return UIView()
    }
    
    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        return UIView()
    }
    
}
