//
//  SpeakEleDebriefViewCtr.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/8/4.
//

import UIKit

class SpeakEleDebriefViewCtr: SpeakEleBaseViewCtr {

    
    private var selectIdx = -1
    
    enum DebAndCorrectState {
        case correct
        case debrie
    }
    
    private var state:DebAndCorrectState = .correct
    @IBOutlet weak var SpeakDebrieTableView: UITableView!
    let viewModel = SpeakProgressNetViewModel()
    
    @IBOutlet weak var NoDataView: UILabel!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        if self.state == .correct {
            self.title = "Correct"
        }else{
            self.title = "Debrief"
        }
        self.NoDataView.isHidden = true
        SpeakAlertHUD.share.show()
        viewModel.correctList(param: ["isError":state == .correct ? 1 : 0]) {[weak self] (su, data:[SpeakProgressCorrect]?) in
            if su {
                self?.datasource = data
                self?.SpeakDebrieTableView.reloadData()
            }
            self?.NoDataView.isHidden = ((self?.datasource?.count ?? 0) > 0)
            SpeakAlertHUD.share.disMiss()
        }
    }
    
    override func setup() {
        self.view.backgroundColor = .init(hex: 0xF6F7F9)
        SpeakDebrieTableView.delegate = self
        SpeakDebrieTableView.dataSource = self
        SpeakDebrieTableView.separatorStyle = .none
        SpeakDebrieTableView.sectionHeaderTopPadding = 0
        SpeakDebrieTableView.sectionHeaderHeight = 0.01
        SpeakDebrieTableView.sectionFooterHeight = 20
        SpeakDebrieTableView.register(UINib(nibName: SpeakEleDebriefViewCell.id, bundle: nil), forCellReuseIdentifier: SpeakEleDebriefViewCell.id)
        SpeakDebrieTableView.showsVerticalScrollIndicator = false
        SpeakDebrieTableView.showsHorizontalScrollIndicator = false
    }
    
    init(state:DebAndCorrectState) {
        self.state = state
        super.init(nibName: "SpeakEleDebriefViewCtr", bundle: nil)
    }
    
    var datasource:[SpeakProgressCorrect]?
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
}


extension SpeakEleDebriefViewCtr : UITableViewDelegate ,UITableViewDataSource {
    
    func numberOfSections(in tableView: UITableView) -> Int {
        return self.datasource?.count ?? 0
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return 1
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: SpeakEleDebriefViewCell.id, for: indexPath) as! SpeakEleDebriefViewCell
        cell.isOpen = (indexPath.section == self.selectIdx)
        cell.data = self.datasource?[indexPath.section]
        cell.callblack = { [weak self] st in
            self?.navigationController?.popToRootViewController(animated: true)
            let first = self?.navigationController?.viewControllers.first
            guard let vc = first as? SpeakEleTabbarViewCtr else { return }
            vc.selectIndex = 0
        }
        return cell
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        if selectIdx != indexPath.section {
            if selectIdx >= 0 {
                if let cell = tableView.cellForRow(at: indexPath) as? SpeakEleDebriefViewCell ,
                   let cellF = tableView.cellForRow(at: IndexPath(row: 0, section: selectIdx)) as? SpeakEleDebriefViewCell {
                    cell.isOpen = true
                    cellF.isOpen = false
                }
            }else{
                if let cell = tableView.cellForRow(at: indexPath) as? SpeakEleDebriefViewCell {
                    cell.isOpen = true
                }
            }
            selectIdx = indexPath.section
        }else{
            selectIdx = -1
            if let cell =  tableView.cellForRow(at: indexPath) as? SpeakEleDebriefViewCell {
                cell.isOpen = false
            }
        }
        tableView.beginUpdates()
        tableView.reloadData()
        tableView.endUpdates()
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        return UIView()
    }
    
    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        return UIView()
    }
}
 
