//
//  SpeakSearchTextField.swift
//  SpeakEasyLearnEnglish
//
//  Created by edy on 2025/7/30.
//

import UIKit

class SpeakSearchTextField: UITextField {

    class func xib() -> SpeakSearchTextField {
        let nib = UINib(nibName: "SpeakSearchTextField", bundle: nil).instantiate(withOwner: nil).first as! SpeakSearchTextField
        return nib
    }
    
    override func awakeFromNib() {
        super.awakeFromNib()
        icon.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(12)
            make.centerY.equalToSuperview()
        }
    }
    
    private lazy var icon: UIImageView = {
        let i = UIImageView(image: UIImage(named: "icon_search"))
        self.addSubview(i)
        return i
    }()

    let leftInset:CGFloat = 44
    
    open override func textRect(forBounds bounds: CGRect) -> CGRect {
        var bound = super.textRect(forBounds: bounds)
        bound.origin.x = leftInset
        bound.size.width -= leftInset
        return bound
    }

    open override func placeholderRect(forBounds bounds: CGRect) -> CGRect{
        var bound = super.placeholderRect(forBounds: bounds)
        bound.origin.x = leftInset
        bound.size.width -= leftInset
        return bound
    }

    open override func editingRect(forBounds bounds: CGRect) -> CGRect{
        var bound = super.editingRect(forBounds: bounds)
        bound.origin.x = leftInset
        bound.size.width -= leftInset
        return bound
    }
    
}
